﻿class Band extends Poly {
	static var allBands:Array=[];
	static var top_mc:MovieClip;
	var _pointer:BandPointer;
	var a:Number = 0;
	var b:Number = 8;
	var c:Number = -8;
	var corners:Array;
	//var cc:Number = -1;
	var pCorner:RoundCorner;
	var mouseListener:Object;
	function Band() {
	}
	function init(style:PolyStyle, peg:Peg, pointer:BandPointer) {
		//trace("band.init");
		mouseListener = new Object();
		mouseListener.onMouseMove = draw;
		corners = new Array();
		_style = style;
		style._fillType = "solid";
		_pointer = pointer;
		_pointer._x = peg._x;
		_pointer._y = peg._y;
		corners[0] = new RoundCorner(this, peg._x, peg._y);
		//corners[1] = new RoundCorner(this, peg._x, peg._y);
		pCorner = new RoundCorner(this, _pointer._x, _pointer._y);
		top_mc = this;
		allBands.push(this);
		//draw();
	}
	static function drawAll() {
		for(var i = 0; i < allBands.length; i++) {
			allBands[i].draw();
		}
	}
	function get cc():Number {
		if (pCorner != null) {
			for (var i = 0; i<corners.length; i++) {
				if (corners[i] == pCorner) {
					return i;
				}
			}
		}
		return -1;
	}
	function addCorner(c:RoundCorner):Void {
		//trace("addCorner "+c.id+"@("+c._x+","+c._y+")");
		if (corners.length<2) {
			corners.push(c);
		}
		for (var i = 0; i<corners.length; i++) {
			//trace("initially["+i+"].id="+corners[i].id);
		}
		//
		// Scan for invisible segment
		//
		var p = corners[0];
		var invX = -1;
		var startX:Number = -1;
		var endX:Number = -1;
		var toRemove:Array = new Array();
		for (var i = 0; i<corners.length; i++) {
			var q = corners[(i+1)%corners.length];
			if (!c.canSee(p, q)) {
				invX = i;
				//trace("invisible at:["+invX+"]."+corners[i].id);
				break;
			}
			p = q;
		}
		//
		// Scan for start of run
		//
		if (invX != -1) {
			p = corners[(invX+1)%corners.length];
			for (var i = 0; i<corners.length; i++) {
				var q = corners[(invX+i+2)%corners.length];
				if (c.canSee(p, q)) {
					startX = (invX+i+1)%corners.length;
					//trace("Starts at:["+startX+"]."+corners[startX].id);
					break;
				}
				p = q;
			}
			// 
			// Scan for end of run
			//
			if (startX != -1) {
				p = corners[(startX)%corners.length];
				for (i=0; i<corners.length-1; i++) {
					var q = corners[(startX+1+i)%corners.length];
					var r = corners[(startX+2+i)%corners.length];
					if (c.canSee(p, q)&&c.canSee(q,r)) {
						//trace("push ["+(startX+1+i)%corners.length+"]."+corners[(startX+1+i)%corners.length].id);
						toRemove.push((startX+1+i)%corners.length);
					} else {
						endX = (startX+i)%corners.length;
						//trace("Ends at:["+endX+"]."+corners[endX].id);					
						break;
					}
				}
				p=q;
			}
			//trace("s->e = "+startX+" and "+endX);
			toRemove.sort();
			for (var i = toRemove.length-1; i>=0; i--) {
				//trace("removing = "+toRemove[i]+"["+corners[toRemove[i]].id+"]");
				corners.splice(toRemove[i],1);
				if(toRemove[i]<=startX){
					if(--startX<0) {
						startX +=corners.length-1;
					}
				}
			}
		}
		//
		// add in the new corner after startX
		//
		if (startX != -1) {
			corners.splice(startX+1, 0, c);
		}
		return;
	}
	function addPeg(peg:Peg):Void {
		//trace("addPeg @("+peg._x+","+peg._y+")");
		var c = new RoundCorner(this, peg._x, peg._y);
		addCorner(c);
	}
	function track():Void {
		//trace("t");
		// remove pointer from list of corners
		var ccc = cc;
		//trace(ccc);
		if (ccc>=0) {
			corners.splice(ccc, 1);
		}
		// now insert it again using incremental convex hull
		pCorner._x = _pointer._x;
		pCorner._y = _pointer._y;
		//trace(pCorner+":"+pCorner.id+":"+pCorner._label);
		//pCorner._label._x = pCorner._x;
		//pCorner._label._y = pCorner._y;
		addCorner(pCorner);
		draw();
	}
	function draw():Void {
		//trace("d");
		clear();
		_style.beginPoly(this);
		if (corners.length == 1) {
			corners[0].drawRound();
		} else {
			var rot = corners[corners.length-1].bearing(corners[0]);
			corners[0].startDrawingWith(rot);
			//trace(rot);
			for (var i = 0; i<corners.length-1; i++) {
				rot = corners[i].drawTo(rot, corners[i+1], false);
				//trace(rot);
			}
			corners[corners.length-1].drawTo(rot, corners[0], true);
		}
		_style.endPoly(this);
	}
	function onPress() {
		//trace("band press");
		swapDepths(Band.top_mc);
		/*
								if(corners.length ==2) {
									for(var i = 0; i < corners.length; i++) {
										trace("corners["+i+"].id="+corners[i].id);
									}
								}
								*/
		addCorner(pCorner);
		//swapDepths(_parent._pointer);
		_pointer.activate();
	}
	function onRelease() {
		//trace("band.release");
		var ccc = cc;
		//trace(ccc);
		if (ccc>=0) {
			corners.splice(ccc, 1);
		}
		_pointer.deactivate();
		/*
								var peg = _pointer.pegHit();
								if (peg != null) {
									trace("adding peg @("+peg._x + ","+peg._y+")");
									addPeg(peg);
								}
								*/
		var ccc = cc;
		//trace("ccc="+ccc);
		if (ccc>=0) {
			corners.splice(ccc, 1);
		}
		draw();
	}
	function onReleaseOutside() {
		onRelease();
	}
}
