/*
 * Decompiled with CFR 0.152.
 */
package com.keypress.Gobjects;

import com.keypress.Gobjects.GObject;
import com.keypress.Gobjects.SimpleMeasure;
import com.keypress.Gobjects.equFormCompOp;
import com.keypress.Gobjects.exprToken;
import com.keypress.Gobjects.numericConstant;
import com.keypress.Gobjects.parseEvalFailure;
import com.keypress.Gobjects.predefFunc;
import com.keypress.Gobjects.variableRef;

public class parseList {
    static final int addition_Op = 1;
    static final int subtraction_Op = 2;
    static final int multiplication_Op = 3;
    static final int division_Op = 4;
    static final int exponentiation_Op = 5;
    static final int terminal_Op = 6;
    static final int openParen_Op = 7;
    static final int openPredefFunc_Op = 8;
    static final int negation_Op = 9;
    static final int closeParen_Op = 10;
    static final int numericConstant_Op = 11;
    static final int variableRef_Op = 12;
    static final int equFormComponent_Op = 13;
    static final int Optimize_MaxTokens = 40;
    private exprToken[] tokens;
    private GObject owningGObj;

    private void buildTokenList(String theExpr) {
        int numTokens = 0;
        int pos = 0;
        while (pos < theExpr.length()) {
            char next = theExpr.charAt(pos);
            if (next == ' ') {
                ++pos;
                continue;
            }
            if (next >= 'A' && next <= 'Z') {
                this.tokens[numTokens++] = new variableRef(next - 65);
                ++pos;
                continue;
            }
            if (next == '#') {
                this.tokens[numTokens++] = new equFormCompOp(theExpr.charAt(pos + 1) - 65, theExpr.charAt(pos + 2) - 48);
                pos += 3;
                continue;
            }
            if (next == '@') {
                int predef = 0;
                predef = "sin_".regionMatches(0, theExpr, ++pos, 4) ? 1 : ("cos_".regionMatches(0, theExpr, pos, 4) ? 2 : ("abs_".regionMatches(0, theExpr, pos, 4) ? 3 : ("sqrt".regionMatches(0, theExpr, pos, 4) ? 4 : ("ln__".regionMatches(0, theExpr, pos, 4) ? 5 : ("rond".regionMatches(0, theExpr, pos, 4) ? 6 : ("trnc".regionMatches(0, theExpr, pos, 4) ? 7 : ("acos".regionMatches(0, theExpr, pos, 4) ? 8 : ("asin".regionMatches(0, theExpr, pos, 4) ? 9 : ("atan".regionMatches(0, theExpr, pos, 4) ? 10 : ("log_".regionMatches(0, theExpr, pos, 4) ? 11 : ("sgn_".regionMatches(0, theExpr, pos, 4) ? 12 : ("tan_".regionMatches(0, theExpr, pos, 4) ? 13 : -1))))))))))));
                this.tokens[numTokens++] = new predefFunc(predef);
                pos += 4;
                continue;
            }
            if (next == '+') {
                this.tokens[numTokens++] = new exprToken(1);
                ++pos;
                continue;
            }
            if (next == '-') {
                this.tokens[numTokens++] = new exprToken(2);
                ++pos;
                continue;
            }
            if (next == '*') {
                this.tokens[numTokens++] = new exprToken(3);
                ++pos;
                continue;
            }
            if (next == '/') {
                this.tokens[numTokens++] = new exprToken(4);
                ++pos;
                continue;
            }
            if (next == '^') {
                this.tokens[numTokens++] = new exprToken(5);
                ++pos;
                continue;
            }
            if (next == '!') {
                this.tokens[numTokens++] = new exprToken(9);
                ++pos;
                continue;
            }
            int numDigits = 1;
            char aDigit = theExpr.charAt(pos + numDigits);
            while (aDigit >= '0' && aDigit <= '9' || aDigit == '.') {
                aDigit = theExpr.charAt(pos + ++numDigits);
            }
            String temp = theExpr.substring(pos, pos + numDigits);
            this.tokens[numTokens++] = new numericConstant(Double.valueOf(temp));
            pos += numDigits;
        }
    }

    private int countTokens(String theExpr) {
        int numTokens = 0;
        int pos = 0;
        boolean skipping = false;
        while (pos < theExpr.length()) {
            char next = theExpr.charAt(pos);
            if (next == ' ') {
                ++pos;
                skipping = false;
                continue;
            }
            if (next >= 'A' && next <= 'Z') {
                ++numTokens;
                ++pos;
                skipping = false;
                continue;
            }
            if (next == '@') {
                ++numTokens;
                pos += 5;
                skipping = false;
                continue;
            }
            if (next == '#') {
                pos += 3;
                ++numTokens;
                continue;
            }
            if (next == '+' || next == '-' || next == '/' || next == '*' || next == '^' || next == '!') {
                ++numTokens;
                ++pos;
                skipping = false;
                continue;
            }
            if (!skipping) {
                ++numTokens;
            }
            ++pos;
            skipping = true;
        }
        return numTokens;
    }

    public parseList(String theExpr, GObject owner) {
        this.owningGObj = owner;
        this.tokens = new exprToken[this.countTokens(theExpr)];
        this.buildTokenList(theExpr);
    }

    public double evaluate() throws parseEvalFailure {
        double[] stack = new double[40];
        int stackTop = -1;
        int start = 0;
        int stop = this.tokens.length;
        try {
            while (start < stop) {
                switch (this.tokens[start].tokenType()) {
                    case 11: {
                        exprToken exprToken2 = (numericConstant)this.tokens[start];
                        stack[++stackTop] = exprToken2.Value;
                        break;
                    }
                    case 12: {
                        ++stackTop;
                        exprToken exprToken2 = (variableRef)this.tokens[start];
                        GObject child = this.owningGObj;
                        SimpleMeasure aParent = (SimpleMeasure)child.getParent(((variableRef)exprToken2).theParent);
                        if (!aParent.isDefined) {
                            throw new parseEvalFailure();
                        }
                        stack[stackTop] = aParent.value;
                        break;
                    }
                    case 13: {
                        stack[++stackTop] = ((equFormCompOp)this.tokens[start]).getEquFormComponent(this.owningGObj);
                        break;
                    }
                    case 8: {
                        stack[stackTop] = ((predefFunc)this.tokens[start]).apply(stack[stackTop]);
                        break;
                    }
                    case 1: {
                        stack[--stackTop] = stack[stackTop] + stack[1 + stackTop];
                        break;
                    }
                    case 2: {
                        stack[--stackTop] = stack[stackTop] - stack[1 + stackTop];
                        break;
                    }
                    case 3: {
                        stack[--stackTop] = stack[stackTop] * stack[1 + stackTop];
                        break;
                    }
                    case 4: {
                        stack[--stackTop] = stack[stackTop] / stack[1 + stackTop];
                        break;
                    }
                    case 5: {
                        stack[--stackTop] = Math.pow(stack[stackTop], stack[1 + stackTop]);
                        break;
                    }
                    case 9: {
                        stack[stackTop] = -stack[stackTop];
                    }
                }
                ++start;
            }
        }
        catch (Exception exception) {
            throw new parseEvalFailure();
        }
        return stack[stackTop];
    }
}

