/*
 * Decompiled with CFR 0.152.
 */
package com.keypress.Gobjects;

import com.keypress.Gobjects.Draggable;
import com.keypress.Gobjects.GObject;
import com.keypress.Gobjects.PeriodicActionButton;
import com.keypress.Gobjects.gPoint;
import java.awt.Color;
import java.awt.Font;

public class moveAction
extends PeriodicActionButton {
    private int numMovementPairs;
    private int numRemainingFrames = 0;
    private double pixelsPerFrame;
    private double[] dx;
    private double[] dy;
    private double[] destX;
    private double[] destY;

    public moveAction(int left, int top, String actionLabel, Font myFont, Color backFillColor, GObject[] parents, double pixelsPerFrame) {
        super(parents, parents.length, left, top, backFillColor, actionLabel, myFont);
        this.numMovementPairs = parents.length / 2;
        this.pixelsPerFrame = pixelsPerFrame;
        this.dx = new double[this.numMovementPairs];
        this.dy = new double[this.numMovementPairs];
        this.destX = new double[this.numMovementPairs];
        this.destY = new double[this.numMovementPairs];
    }

    public synchronized void initializePeriodicAction() {
        double maxJump = 0.0;
        int maxJumpIndex = -1;
        int i = 0;
        while (i < this.numMovementPairs) {
            gPoint dest = (gPoint)this.getParent(i * 2);
            gPoint source = (gPoint)this.getParent(i * 2 + 1);
            if (dest.isExisting() && source.isExisting()) {
                this.destX[i] = dest.getX();
                this.destY[i] = dest.getY();
                this.dx[i] = this.destX[i] - source.getX();
                this.dy[i] = this.destY[i] - source.getY();
                double sum = this.dx[i] * this.dx[i] + this.dy[i] * this.dy[i];
                if (sum > maxJump) {
                    maxJump = sum;
                    maxJumpIndex = i;
                }
            } else {
                this.dx[i] = 0.0;
                this.dy[i] = 0.0;
            }
            ++i;
        }
        if (maxJumpIndex >= 0) {
            if (this.pixelsPerFrame != 0.0) {
                this.numRemainingFrames = (int)(Math.sqrt(maxJump) / this.pixelsPerFrame);
                if (this.numRemainingFrames < 1) {
                    this.numRemainingFrames = 1;
                }
                int i2 = 0;
                while (i2 < this.numMovementPairs) {
                    this.dx[i2] = this.dx[i2] / (double)this.numRemainingFrames;
                    this.dy[i2] = this.dy[i2] / (double)this.numRemainingFrames;
                    ++i2;
                }
            } else {
                this.numRemainingFrames = 1;
            }
        } else {
            this.numRemainingFrames = 1;
        }
        this.accessScreenUpdater.wait_and_get_lock("moveInitialize/terminate");
        this.screenUpdaterInitialized = true;
        this.sketch.AddContinuousScreenUpdatingTask();
        this.accessScreenUpdater.release_lock();
    }

    public synchronized boolean periodicAction() {
        --this.numRemainingFrames;
        this.sketch.getGObjectsLock().wait_and_get_lock("move/periodicAction");
        int i = 0;
        while (i < this.numMovementPairs) {
            if (this.dx[i] != 0.0 || this.dy[i] != 0.0) {
                gPoint cfr_ignored_0 = (gPoint)this.getParent(i * 2);
                gPoint source = (gPoint)this.getParent(i * 2 + 1);
                if (this.numRemainingFrames == 0) {
                    ((Draggable)((Object)source)).dragTo(this.destX[i], this.destY[i], false);
                } else {
                    ((Draggable)((Object)source)).dragTo(this.dx[i] + source.getX(), this.dy[i] + source.getY(), false);
                }
            }
            ++i;
        }
        this.sketch.getGObjectsLock().release_lock();
        return this.numRemainingFrames > 0;
    }

    public void modifySpeed(double percentage) {
        boolean wasZero = this.pixelsPerFrame == 0.0;
        this.pixelsPerFrame *= percentage;
        if (this.pixelsPerFrame == 0.0 && !wasZero) {
            this.pixelsPerFrame = Double.MIN_VALUE;
        }
        this.accessClickedDown.wait_and_get_lock("modifySpeed");
        if (this.clickedDown) {
            this.terminatePeriodicAction();
            this.initializePeriodicAction();
        }
        this.accessClickedDown.release_lock();
    }
}

