﻿class SorterSet extends MovieClip {
	var _set:Array;
	var left_btn:MovieClip;
	var right_btn:MovieClip;
	var _setValues:Array;
	var _sx:Number = 0;
	var linkIndex:Number;
	function SorterSet() {
	}
	function clone(newLinkIndex:Number):SorterSet {
		var ss = SorterSet(attachMovie("SorterSet", "sorterSet"+newLinkIndex, 100+newLinkIndex));
		ss.init(_set, newLinkIndex);
		return ss;
	}
	function get setCopy():Array {
		var s = new Array();
		for(var sv in _set) {
			s[sv] = _set[sv].concat();
		}
		return s;
	}
	function expandSet():Void {
		var i = 0;
		_setValues = new Array();
		for (var sv in _set) {
			_setValues[i] = new Array();
			_setValues[i++] = _set[sv];
		}
	}
	function init(set:Array, index:Number) {
		_set = new Array();
		for(var sv in set) {
			_set[sv] = set[sv].concat();
		}
		linkIndex = index;
		_sx = 0;
		expandSet();
		// Add extra navigation buttons
		left_btn = attachMovie("LBrace", "lbrace", 5000);
		left_btn._x -= _parent.barWidth/2;
		left_btn._y += _parent.yStep/2;
		left_btn._xscale = left_btn._yscale=150;
		left_btn.onRelease = function() {
			trace("left");
			if (_parent._sx>0) {
				_parent._sx--;
			}
			else {
				_parent._sx = _parent._setValues.length-1;
			}
			_parent.refresh();
		};
		right_btn = attachMovie("RBrace", "rbrace", 5001);
		right_btn._x += _parent.barWidth/2;
		right_btn._y = left_btn._y;
		right_btn._xscale = right_btn._yscale=150;
		right_btn.onRelease = function() {
			trace("right");
			if (_parent._sx<_parent._setValues.length-1) {
				_parent._sx++;
			}
			else {
				_parent._sx = 0;
			}
			_parent.refresh();
		};
	}
	function setOrder(v:Number) {
		for (var j=0; j<_setValues.length; j++) {
			var value = _setValues[j];
			for (var i = value.length; i<v; i++) {
				value[i] = i;
			}
			while (value.length>v) {
				value.pop();
			}
		}
		left_btn._x = -_parent.barWidth/2;
		right_btn._x = _parent.barWidth/2;
	}
	function minOrder():Number {
		var m = 1;
		for (var i = 0; i<_setValues.length; i++) {
			m = Math.max(Zipper.minValueOrder(_setValues[i]), m);
		}
		return m;
	}
	function synch() {
		_parent.values[linkIndex] = _setValues[_sx];
	}
	function refresh() {
		_parent.values[linkIndex] = _setValues[_sx];
		//
		// TODO: WORRY ABOUT VALUE LENGTHS
		//
		trace("reDraw: "+_parent.values[linkIndex]);
		_parent.reDraw(0);
	}
	function composeBeforeSet(oss:SorterSet):Void {
		var newSet:Array;
		newSet = new Array();
		for(var sv in _set) {
			for(var ov in oss._set) {
				var value:Array = Zipper.compose(oss._set[ov],_set[sv]);
				var cycles:String = Zipper.cycleString(value);
				if(newSet[cycles]==null) {
					newSet[cycles]=value;
				}
				else {
					delete value;
				}
			}
		}
		for(var sv in _set) {
			delete _set[sv];
		}
		delete _set;
		_set = newSet;
		expandSet();
	}
	function composeBefore(value:Array) {
		// 
		// Compose set before value
		//
		for(var sv in _set) {
			_set[sv]=Zipper.compose(value, _set[sv]);
		}
		expandSet();
		//
		// TODO: The sv properties need renaming to the new cycleStringValues.
		//
	}
	function composeAfter(value:Array):SorterSet {
		for(var sv in _set) {
			_set[sv]=Zipper.compose(_set[sv], value);
		}
		expandSet();
		//
		// TODO: The sv properties need renaming to the new cycleStringValues.
		//
		return this;
	}
}
