﻿import Expression;
class Mbox extends MovieClip {
	var _e:Expression;
	var _caret = 0;
	var _line = 0;
	var _fmt:TextFormat = null;
	var _id = 0;
	var _lineHeight = 30;
	function Mbox() {
		_e = new Expression();
		_fmt = new TextFormat();
		_fmt.color = 0x003333;
		//_fmt.font = "_sans";
		_fmt.size = 30;
		_fmt.italic = true;
		_fmt.leftMargin=5;
		//_fmt.rightMargin;
	}
	function set expr(e:Expression):Void {
		_e = e;
	}
	function get expr():Expression {
		return _e;
	}
	function drawString(s):TextField {
		var xt:Object = _fmt.getTextExtent(s);
		_id++;
		createTextField("expr"+_id, _id, 0, 0, xt.textFieldWidth+11, xt.textFieldHeight);
		var _txt = this["expr"+_id];
		_txt.autoSize = "none";
		_txt.html = false;
		_txt.text += s;
		_txt.setTextFormat(_fmt);
		_lineHeight = xt.textFieldHeight;
		_txt._x = _caret;
		_txt._y = _line*_lineHeight;
		_caret += xt.textFieldWidth;
		return _txt;
	}
	function drawStringArray(sa:Array):TextField {
		var s:String = "";
		for (var i = 0; i<sa.length; i++) {
			s += sa[i];
		}
		var xt:Object = _fmt.getTextExtent(s);
		_id++;
		createTextField("expr"+_id, _id, 0, 0, xt.textFieldWidth+11, xt.textFieldHeight);
		var _txt = this["expr"+_id];
		_txt.autoSize = "none";
		_txt.html = false;
		_txt.text += s;
		_txt.setTextFormat(_fmt);
		_lineHeight = xt.textFieldHeight;
		_txt._x = _caret;
		_txt._y = _line*_lineHeight;
		_caret += xt.textFieldWidth;
		return _txt;
	}
	function draw(e:Expression):Void {
		switch (e.type) {
		case Expression.TERM :
			drawString(e.term);
			break;
		case Expression.FENCED :
			drawString("(");
			draw(e.fenced);
			drawString(")");
			break;
		case Expression.LIST :
			for (var i = 0; i<e.value.length; i++) {
				draw(e.value[i]);
			}
			return;
		}
		if (e.power != 1) {
			var _txt = drawString(e.power);
			_txt._xscale = _txt._yscale=70;
			_txt._x +=5;
			_caret -= 5;
			//_txt._y -= _lineHeight*0.2;
		}
	}
	function newline() {
		++_line;
		_caret = 0;
	}
}
