﻿import mx.controls.Tree;
class LibraryTree extends MovieClip {
	var treeListener:Object;
	var tree:Tree;
	var factories:XMLNode;
	var sets:XMLNode;
	function LibraryTree() {
	}
	function init() {
		//
		// set up the listener
		//
		treeListener = new Object();
		treeListener.change = function(evt:Object) {
			trace("changed this="+this+"target.parent="+evt.target._parent);
			var controls:LibraryTree = evt.target._parent;
			var treeListener = controls.treeListener;
			if ((getTimer()-treeListener._time)<1000) {
				if (evt.target.selectedItem == treeListener._oldItem) {
					var node:XMLNode = evt.target.selectedNode;
					var attr = node.attributes;
					//var url = attr.url;
					trace("double click url = "+attr.url);
					switch (attr.url) {
					case "Zipper" :
						var setName = node.parentNode.attributes.label;
						var value = _global.factories[setName][attr.label];
						var zip:Zipper = _level0.factoryPullOut.factory.createZip(value);
						zip._x = 100;
						zip._y = 200;
						break;
					case "ZipSet" :
						var setName = attr.label;
						var zipSet:Zipper = _level0.factoryPullOut.factory.createZipSet(setName);
						zipSet._x = 100;
						zipSet._y = 200;
						break;
					default :
						if (attr.url != null) {
							_level0.getURL(attr.url);
						}
					}
				}
				treeListener._oldItem = evt.target.selectedItem;
				treeListener._time = getTimer();
			}
			treeListener._oldItem = evt.target.selectedItem;
			treeListener._time = getTimer();
		};
		//
		// populate the tree with static items
		//
		trace("making tree");
		tree = this["tree"];
		tree.addEventListener("change", treeListener);
		var help = tree.addTreeNode("Help");
		help.addTreeNode("Making Shuffles").attributes.url = "http://nrich.maths.org/content/id/2789/factories.swf";
		help.addTreeNode("Manipulating Shuffles").attributes.url = "http://nrich.maths.org/content/id/2789/manipulating.swf";
		help.addTreeNode("Identity and Order").attributes.url = "http://nrich.maths.org/content/id/2668/shriekIntro.swf";
		var problems = tree.addTreeNode("Problems");
		problems.addTreeNode("Shuffle Shriek").attributes.url = "http://nrich.maths.org/public/viewer.php?obj_id=2668";
		problems.addTreeNode("Sheffuls").attributes.url = "http://nrich.maths.org/public/viewer.php?obj_id=2781";
		problems.addTreeNode("Zodiac").attributes.url = "http://nrich.maths.org/public/viewer.php?obj_id=2788";
		problems.addTreeNode("Stars").attributes.url = "http://nrich.maths.org/public/viewer.php?obj_id=2669";
		factories = tree.addTreeNode("Saved Sets");
		tree.setIsBranch(factories, true);
		//sets = tree.addTreeNode("Saved Sets");
		//tree.setIsBranch(sets, true);
	}
	//
	// TODO: Use TreeDataProvider API here
	//
	function updateSets() {
		while (sets.hasChildNodes()) {
			sets.firstChild.removeTreeNode();
		}
		for (var set in _global.sets) {
			var setNode = sets.addTreeNode(set);
			for (var sv in _global.sets[set]) {
				setNode.addTreeNode(sv);
			}
		}
	}
	function sn2Title(setName:String):String {
		return ("Factory "+setName);
	}
	function renameFactory(oldSet:String, newSet:String) {
		trace("renaming "+oldSet+" to "+newSet);
		var f:XMLNode;
		for (f=factories.firstChild; f != null; f=f.nextSibling) {
			if (oldSet == f.attributes.label) {
				f.attributes.label = newSet;
				break;
			}
		}
		_level0.factoryPullOut.renameFactory(sn2Title(oldSet), sn2Title(newSet), newSet);
	}
	function updateFactories() {
		var f:XMLNode;
		// Delete surplus factories
		for (f=factories.firstChild; f != null; f=f.nextSibling) {
			var found:Boolean = false;
			for (var set in _global.factories) {
				if (set == f.attributes.label) {
					trace("Don't delete "+set);
					found = true;
					break;
				}
			}
			if (!found) {
				// delete this factory
				_level0.factoryPullOut.deleteFactory(sn2Title(f.attributes.label));
				trace("deleting this factory "+f.attributes.label);
			}
		}
		// Create new factories
		for (var set in _global.factories) {
			var found:Boolean = false;
			for (f=factories.firstChild; f != null; f=f.nextSibling) {
				var found:Boolean = false;
				//trace("f.label="+f.attributes.label);
				if (set == f.attributes.label) {
					//trace("match on " + set);
					found = true;
					break;
				}
			}
			if (!found) {
				// create this factory
				trace("creating new Factory "+set);
				//_level0.factoryPullOut.createFactory();
				var gf:GeneratorFactory = _level0.factoryPullOut.createFactory(sn2Title(set), _level0, "GeneratorFactory", set, 4, {setName:set});
				_level0.factoryPullOut.hideAllBut(gf);
			}
		}
		while (factories.hasChildNodes()) {
			var f:XMLNode = factories.firstChild;
			f.removeTreeNode();
		}
		for (var set in _global.factories) {
			var setNode = factories.addTreeNode(set);
			setNode.attributes.url = "ZipSet";
			for (var sv in _global.factories[set]) {
				var node = setNode.addTreeNode(sv);
				node.attributes.url = "Zipper";
			}
			var gf:GeneratorFactory = _level0.factoryPullOut.factoryByTitle(sn2Title(set));
			trace("updating "+sn2Title(set)+"="+gf);
			if (gf != null) {
				gf.update();
			}
		}
	}
}
