﻿class GeneratorFactory extends BaseFactoryImpl implements ShuffleFactory {
	var _chooser:MovieClip;
	var _setName:String;
	var _set:Array;
	var generators:Array;
	var _index:Number=0;
	function GeneratorFactory() {
	}
	function minimumOrder(_set:Array):Number {
		var minOrder = 1;
		for(var sv in _set) {
			var m = Zipper.minValueOrder(_set[sv]);
			minOrder = Math.max(minOrder, m);
		}
		return minOrder;
	}
	function update():Void {
		trace("UPDATE " + _setName);
		var oldZips:Array = _zips;
		_iObj.order = _value.length;
		init(_iObj);
		_zips=oldZips;
	}
	function rename(newName:String):Void {
		_chooser.sym_txt.text = newName.toLowerCase();
		_iObj.setName = newName;
		_setName = newName;
	}
	function init(iObj:Object):Void {
		_factorySize = 15;
		_setName = iObj.setName;
		_set =_global.factories[_setName];
		generators = new Array();
		for(var sv in _set) {
			generators.push(_set[sv]);
		}
		iObj.initial=generators[0];
		//trace("set = " + _set + "value="+_set[0]);
		super.init(iObj);
		var xOffset = 200;
		grow_btn._x += xOffset;
		shrink_btn._x += xOffset;
		_bar._x += xOffset;
		_chooser = attachMovie("GenericChooser", "chooser", 11);
		_chooser._x = shrink_btn._x;
		_chooser._y = barOffset - 40;
		_chooser._xscale = 200;
		_chooser._yscale = 200;
		_chooser.sym_txt.text = _setName.toLowerCase();
		_chooser.n_txt.text = _index;
		_chooser.plus_btn.onRelease = function() {
			var n = Number(_parent.n_txt.text);
			var gen = _parent._parent.generators;
			n = (n+1)%gen.length;
			_parent.n_txt.text = n;
			_parent._parent.reDraw({initial:gen[n], setName:_parent._parent._setName});
		};
		_chooser.minus_btn.onRelease = function() {
			//trace("minus");
			var n = Number(_parent.n_txt.text);
			var gen = _parent._parent.generators;
			n = (n-1);
			while (n<0) {
				n += gen.length;
			}
			_parent.n_txt.text = n;
			_parent._parent.reDraw({initial:gen[n], setName:_parent._parent._setName});
		};
		shrink_btn.onRelease = function() {
			//trace("shrnk parent=" + _parent);
			var minSetOrder = _parent.minimumOrder(_parent._set);
			//trace("minSetOrder = " + minSetOrder);
			var order = _parent._value.length;
			//trace("order = " + order);
			//trace("_parent.minOrder() = " + _parent.minOrder());
			if (order>_parent.minOrder() && order>minSetOrder) {
				_parent._value.pop();
				_parent.shrinkGenerators();
				var n = Number(_parent._chooser.n_txt.text);
				var gen = _parent.generators;
				_parent.reDraw({initial:gen[n], setName:_parent._setName});
			}
		};
		grow_btn.onRelease = function() {
			trace("grow parent=" + _parent);
			var i = _parent._value.length;
			if (i<_parent._factorySize) {
				_parent._value[i] = i;
				_parent.growGenerators();
				var n = Number(_parent._chooser.n_txt.text);
				var gen = _parent.generators;
				_parent.reDraw({initial:gen[n], setName:_parent._setName});
			}
		};
	}
	function shrinkGenerators():Void {
		for(var i = 0; i < generators.length; i++) {
			generators[i].pop();
		}
	}
	function growGenerators():Void {
		for(var i = 0; i < generators.length; i++) {
			var gen = generators[i];
			gen.push(gen.length);
		}		
	}
}
