﻿import mx.controls.ComboBox;
class FactoryPullOut extends PullOut {
	var _dropLength:Number = 40;
	var _dropRate:Number = 6;
	var _y0:Number;
	var _factories:Array;
	var _fx:Number = 0;
	var _fmt:TextFormat;
	var _title:TextField;
	var instanceNameBase = "fac";
	function init() {
		super.init();
		_open = true;
		_factories = new Array();
		_fmt = new TextFormat();
		//_fmt.italic=true;
		//_fmt.bold = true;
		_title = this["pullOutTitle"];
		_title.setTextFormat(_fmt);
		_title.autoSize = "left";
		// Initialise set manipulation GUI
		this["next_btn"].onRelease = function() {
			trace(_parent + ".nextFactory()");
			_parent.nextFactory();
		};
		this["prev_btn"].onRelease = function() {
			trace(_parent + ".prevFactory()");
			_parent.prevFactory();
		};
	}
	function renameFactory(oldTitle:String, newTitle:String, newSet):Void {
		for(var i = 0; i < _factories.length; i++) {
			var f = _factories[i];
			if(f.title==oldTitle) {
				f.title=newTitle;
				f.factory.rename(newSet);
			}
			if(i==_fx) {
				this["pullOutTitle"].text = newTitle;
			}
		}
	}
	function createFactory(title:String, parent:MovieClip, idName:String, instanceName:String, level:Number, iObj:Object):ShuffleFactory {
		//var _mc:MovieClip = parent.getInstanceAtDepth(level);
		instanceName = instanceNameBase + _factories.length;
		var _mc = attachMovie(idName, instanceName, _factories.length);
		//trace(_mc);
		var instance:ShuffleFactory = ShuffleFactory(_mc);
		//trace(instance._x+","+instance._y);
		instance.init(iObj);
		_factories.push({title:title, factory:instance});
		return instance;
	}
	function deleteFactory(title:String):Void {
		for(var i = 0; i < _factories.length; i++) {
			var f = _factories[i];
			if(f.title == title) {
				f.factory.removeMovieClip();
				_factories.splice(i, 1);
				if(_fx == i) {
					nextFactory();
				}
				return;
			}
		}
	}
	function FactoryPullOut() {
		super();
		//trace("_y="+_y);
		_y0 = _y-_dropLength;
		//trace("_y0="+_y0);
	}
	function slideFactory(dropRate:Number):Void {
		_y += dropRate;
		/*
		for (var i = 0; i<_factories.length; i++) {
			_factories[i].factory._y += dropRate;
		}
		*/
		//_level0.library._y += dropRate;
	}
	function slide4Library(dx) {
		_x += dx;
		/*
		for (var i = 0; i<_factories.length; i++) {
			_factories[i].factory._x += dx;
		}
		*/
	}
	function open() {
		trace("open");
		onEnterFrame = function () {
			if (_y<_y0+_dropLength) {
				slideFactory(Math.min(_dropRate, _y0+_dropLength-_y));
				// _y += _dropRate;
				// _factories[_fx].factory._y += _dropRate;
			} else {
				super.open();
				onEnterFrame = undefined;
			}
		};
	}
	function close() {
		trace("close: _y0="+_y0+" _y="+_y);
		onEnterFrame = function () {
			if (_y-_y0>0.5) {
				slideFactory(-Math.min(_dropRate, _y-_y0));
				// _y -= _dropRate;
				// _factories[_fx].factory._y -= _dropRate;
			} else {
				trace("closed");
				super.close();
				onEnterFrame = undefined;
			}
		};
	}
	function nextFactory() {
		//trace("nextFactory");
		_factories[_fx++].factory.hide();
		_fx = _fx%_factories.length;
		_factories[_fx].factory.show();
		_title.text = _factories[_fx].title;
	}
	function prevFactory() {
		//trace("prevFactory");
		_factories[_fx--].factory.hide();
		if (_fx<0) {
			_fx = _factories.length-1;
		}
		_factories[_fx].factory.show();
		_title.text = _factories[_fx].title;
	}
	function get factory():ShuffleFactory {
		return _factories[_fx].factory;
	}
	function factoryByTitle(title:String):ShuffleFactory {
		for(var i=0; i<_factories.length; i++) {
			var f = _factories[i];
			if(f.title == title) {
				return f.factory;
			}
		}
		return null;
	}
	function hideAllBut(sf:ShuffleFactory):Void {
		for(var i=0; i < _factories.length; i++) {
			var f:ShuffleFactory = ShuffleFactory(_factories[i].factory);
			if(sf != f) {
				f.hide();
			}
			else {
				_fx = i;
				f.show();
				_title.text = _factories[_fx].title;
			}
		}
	}
}
