﻿class DihedralFactory extends BaseFactoryImpl implements ShuffleFactory {
	var _order:Number = 3;
	var _panel:MovieClip;
	var _chooser:MovieClip;
	var _poly:Dihedral;
	var _t:Number = 0;
	var _g:Number = 0;
	var _f:Number = 0;
	var _playing:Object;
	function DihedralFactory() {
	}
	function init(iObj:Object):Void {
		super.init(iObj);
		_factorySize = 20;
		_order = iObj.initial.length;
		_panel = attachMovie("DihedralPanel", "panel", 10);
		_panel._x = 30;
		_panel._y = 160+barOffset;
		_chooser = attachMovie("Chooser", "chooser", 11);
		_chooser._xscale = 200;
		_chooser._yscale = 200;
		_chooser._x = -5;
		_chooser._y = barOffset;
		_bar._x += _chooser._width+10;
		grow_btn._x += _chooser._width+10;
		shrink_btn._x += _chooser._width+10;
		_chooser.sym_txt.text = "Turn";
		_chooser.n_txt.text = 0;
		_poly = Dihedral(_panel.attachMovie("Dihedral", "poly", 12));
		_t = 0;
		_poly.init({n:_order, radius:70, fillColor:0xff0000, lineColor:0x000000, lineWidth:5, alpha:60});
		_poly.draw(0, null);
		_poly._x = 0;
		_poly._y = 0;
		_chooser.ft_btn.onRelease = function() {
			switch (_parent.sym_txt.text) {
			case "Turn" :
				_parent.sym_txt.text = "Flip";
				break;
			case "Flip" :
				_parent.sym_txt.text = "Turn";
				break;
			}
			//var n = Number(_parent.n_txt.text);
			//var iObj = _parent._parent.getInitObj(_parent.sym_txt.text == "Flip", n);
			_parent._parent.reDraw(null);
		};
		_chooser.plus_btn.onRelease = function() {
			var n = Number(_parent.n_txt.text);
			n = (n+1)%this._parent._parent._order;
			_parent.n_txt.text = n;
			//var iObj = _parent._parent.getInitObj(_parent.sym_txt.text == "Flip", n);
			_parent._parent.reDraw(null);
		};
		_chooser.minus_btn.onRelease = function() {
			//trace("minus");
			var n = Number(_parent.n_txt.text);
			n = (n-1);
			while (n<0) {
				n += _parent._parent._order;
			}
			_parent.n_txt.text = n;
			//var iObj = _parent._parent.getInitObj(_parent.sym_txt.text == "Flip", n);
			_parent._parent.reDraw(null);
		};
		_panel.play_btn.onRelease = function() {
			var pp = _parent._parent;
			if (pp._playing != null) {
				if (pp._playing.type=="Flip") {
					pp.onEnterFrame = pp.flip;
				} else {
					pp.onEnterFrame = pp.turn;
				}
			}
		};
		_panel.reset_btn.onRelease = function() {
			_parent._parent.reset();
		};
		shrink_btn.onRelease = function() {
			if (_parent._value.length>_parent.minOrder()) {
				_parent._value.pop();
			}
			_parent._order = _parent._value.length;
			_parent.reDraw(null);
			_parent._poly.init({n:_parent._order, radius:70, fillColor:0xff0000, lineColor:0x000000, lineWidth:5, alpha:60});
			_parent._poly.draw(0, null);
		};
		grow_btn.onRelease = function() {
			var i = _parent._value.length;
			if (i<_parent._factorySize) {
				_parent._value[i] = i;
			}
			_parent._order = _parent._value.length;
			_parent.reDraw(null);
			_parent._poly.init({n:_parent._order, radius:70, fillColor:0xff0000, lineColor:0x000000, lineWidth:5, alpha:60});
			_parent._poly.draw(0, null);
		};
	}
	function getInitObj(flip:Boolean, n:Number):Object {
		var value = identityInit(_order);
		if (flip) {
			if (_order%2 != 0) {
				for (var j = 0; j<(_order-1)/2; j++) {
					var s1 = (n+j+1)%_order;
					var s2 = (n-j-1);
					while (s2<0) {
						s2 += _order;
					}
					trace("order="+_order+" n="+n+" j="+j);
					value = transpose(value, s1, s2);
				}
			} else {
				if (n%2 == 0) {
					for (var j = 0; j<_order/2-1; j++) {
						var s1 = ((n+2)/2+j)%_order;
						var s2 = ((n-2)/2-j);
						while (s2<0) {
							s2 += _order;
						}
						trace("order="+_order+" n="+n+" j="+j);
						value = transpose(value, s1, s2);
					}
				} else {
					for (var j = 0; j<_order/2; j++) {
						var s1 = ((n+1)/2+j)%_order;
						var s2 = ((n-1)/2-j);
						while (s2<0) {
							s2 += _order;
						}
						trace("order="+_order+" n="+n+" j="+j);
						value = transpose(value, s1, s2);
					}
				}
			}
		} else {
			// turn through n steps
			for (var j = 0; j<n; j++) {
				value.push(value.shift());
			}
		}
		return {initial:value};
	}
	function transpose(value:Array, j:Number, k:Number):Array {
		trace("("+j+","+k+")");
		var temp = value[j];
		value[j] = value[k];
		value[k] = temp;
		return value;
	}
	function turn() {
		var n = _order-_playing.n;
		if (_t<1.01) {
			_poly.rotate(n, _t);
			_t += 0.1/(n+1);
		} else {
			_t = 0;
			onEnterFrame = undefined;
		}
	}
	function flip() {
		//trace("flip");
		var n = _order-_playing.n;
		if (_t<1.01) {
			_poly.reflect(n, _t);
			_t += 0.1;
		} else {
			_t = 0;
			//			_f = (n+1)%_order;
			onEnterFrame = undefined;
		}
	}
	function reDraw(ignore:Object):Void {
		var iObj = getInitObj(_chooser.sym_txt.text == "Flip", Number(_chooser.n_txt.text));
		//trace("iObj="+iObj.initial);
		super.reDraw(iObj);
	}
	static var valueShuffles:Array = null;
	function getShuffle(value:Array):Object {
		if (valueShuffles[String(value)] == undefined) {
			if (valueShuffles == null) {
				valueShuffles = new Array();
			}
			trace("getShuffle("+value+")"+" order="+_order);
			for (var n = 0; n<_order; n++) {
				var o:Object = getInitObj(true, n);
				trace("o.initial="+o.initial);
				valueShuffles[String(o.initial)] = {order:_order, type:"Flip", n:n};
				trace("valueShuffles="+valueShuffles[String(o.initial)]);
				o = getInitObj(false, n);
				trace("o.initial="+o.initial);
				valueShuffles[String(o.initial)] = {order:_order, type:"Turn", n:n};
				trace("valueShuffles="+valueShuffles[String(o.initial)]);
			}
		}
		return valueShuffles[String(value)];
	}
	function reset():Void {
		trace("RESET");
		_poly.init({n:_order, radius:70, fillColor:0xff0000, lineColor:0x000000, lineWidth:5, alpha:60});
		_poly.draw(0, null);
	}
	function play(shuffle:Object):Void {
		trace("playing "+shuffle.type+" "+shuffle.n);
		_playing = shuffle;
		if (shuffle.order == _order) {
			if (shuffle.type == "Flip") {
				onEnterFrame = flip;
			} else if (shuffle.type == "Turn") {
				onEnterFrame = turn;
			}
		}
	}
	function canPlay():Boolean {
		return true;
	}
	function readyToPlay():Boolean {
		return onEnterFrame == undefined;
	}
}
