﻿class BaseFactoryImpl extends MovieClip implements ShuffleFactory {
	var id:Number = 100;
	var _bar:Bar;
	var _iSize:Number = 20;
	var _zip:Zipper;
	var _value:Array;
	var grow_btn:MovieClip;
	var shrink_btn:MovieClip;
	var _onPress:Function;
	var _onRelease:Function;
	var _zips:Array;
	var _zipSets:Array;
	var _factorySize = 24;
	var _iObj:Object;
	//var _menu:mx.controls.Menu;
	static var barOffset:Number = 90;
	function BaseFactoryImpl() {
	}
	function identityInit(n:Number):Array {
		var initialValue = new Array();
		for (var i = 0; i<n; i++) {
			initialValue[i] = i;
		}
		return initialValue;
	}
	function minOrder():Number {
		var maxOrder = 1;
		for (var i = 0; i<_zips.length; i++) {
			if (_zips[i].minOrder()>maxOrder) {
				maxOrder = _zips[i].minOrder();
			}
		}
		return maxOrder;
	}
	function init(iObj:Object):Void {
		_iObj = iObj;
		_bar = Bar(attachMovie("Bar", "bar", 1));
		_value = iObj.initial.concat();
		_zips = new Array();
		_zipSets = new Array();
		_bar.init(_value, _iSize, 120, "Pad");
		shrink_btn = attachMovie("Shrink_btn", "shrink_btn", 2);
		//		shrink_btn._x += _bar._width/2;
		grow_btn = attachMovie("Grow_btn", "grow_btn", 3);
		//grow_btn._x = shrink_btn._x+shrink_btn._width;
		//trace(_bar._y+":"+shrink_btn._y+":"+grow_btn._y);
		grow_btn._x -= _bar._width/2;
		shrink_btn._x = grow_btn._x-grow_btn._width;
		_bar._y = shrink_btn._y=grow_btn._y=barOffset;
		//#### why doesn't the following work?
		//this.setMask(_level0.back2);
		shrink_btn.onRelease = function() {
			if (_parent._value.length>_parent.minOrder()) {
				_parent._value.pop();
				//_parent.reDraw({initial:_parent._value});
				var v = _parent.identityInit(_parent._value.length);
				//trace(v);
				_parent.reDraw({initial:v});
			}
		};
		grow_btn.onRelease = function() {
			var i = _parent._value.length;
			if (i<_parent._factorySize) {
				_parent._value[i] = i;
				//	_parent.reDraw({initial:_parent._value});
				var v = _parent.identityInit(_parent._value.length);
				//trace(v);
				_parent.reDraw({initial:v});
			}
		};
		_onPress = _bar.onPress=function () {
			/*
			var zip = _parent._zip=Zipper(_parent.attachMovie("Zipper", "zip"+_parent.id++, _parent.id));
			_parent._zips.push(zip);
			trace("startDrag: "+_parent+":"+zip);
			zip._x = _x;
			zip._y = barOffset;
			zip.init(_value, _iSize, _level0.popupMenu["edit"].attributes.selected);
			zip._topBar.onPress();
			zip.shuffle = _parent.getShuffle();
			*/
			var zip:Zipper = _parent.createZip(_value);
			zip._x = _x;
			zip._y = barOffset;
			zip._topBar.onPress();
		};
		_onRelease = _bar.onReleaseOutside=_bar.onRelease=function () {
			stopDrag();
			var zip = _parent._zip;
			trace("stopDrag: "+_parent+":"+zip);
			// trace("zip.y="+zip._y+" y="+_y);
			if (Math.abs(zip._y-_y)<20) {
				zip._y += 100;
			}
		};
		_xscale = 50;
		_yscale = 50;
		_x = 10+(_value.length*_iSize+shrink_btn._width+grow_btn._width)*_xscale/100;
		_y = -10;
		// Register a mouseListener to trap 'Deselect All' events
		Mouse.addListener(this);
	}
	function createZip(value:Array):Zipper {			
		var zip = _zip=Zipper(attachMovie("Zipper", "zip"+id++, id));
		_zips.push(zip);
		zip.init(value, _iSize, _level0.popupMenu["edit"].attributes.selected);
		zip.shuffle = getShuffle();
		return zip;
	}
	function createZipSet(setName:String):Zipper {	
		trace("Creating ZipSet: " + setName);
		var zip:Zipper = Zipper(attachMovie("Zipper", "zip"+id++, id));
		zip.initAsSet(_global.factories[setName], _iSize);
		_zips.push(zip);
		return zip;
	}
	//
	// Mouse up on background deselects all
	//
	function onMouseUp() {
		if (_global.freezeSelection) {
			return;
		}
		for (var i = 0; i<_zips.length; i++) {
			if (_zips[i].hitTest(_level0._xMouse, _level0._yMouse, false)) {
				return;
			}
		}
		deselectAll();
	}
	function deselectAll():Void {
		for (var i = 0; i<_zips.length; i++) {
			_zips[i].selected = false;
			//trace("deselecting " + _zips[i]);
		}
	}
	function cloneZip(zip:Zipper):Zipper {
		// trace(_parent);
		var newzip = _zip=Zipper(attachMovie("Zipper", "zip"+id++, id));
		_zips.push(newzip);
		newzip._x = zip._x;
		newzip._y = zip._y;
		newzip.init(zip.zipValue, zip.iconSize, _level0.popupMenu["edit"].attributes.selected);
		//newzip._topBar.onPress();
		newzip.shuffle = _parent.getShuffle();
		return newzip;
	}
	function deleteZip(zip:Zipper):Void {
		for (var i = 0; i<_zips.length; i++) {
			if (_zips[i] == zip) {
				for (var j = i+1; j<_zips.length; j++) {
					var lowerZip = _zips[j-1];
					var higherZip = _zips[j];
					var tmpName:String = lowerZip._name;
					lowerZip._name = higherZip._name;
					higherZip._name = tmpName;
					higherZip.swapDepths(lowerZip);
				}
				_zips.splice(i, 1);
				zip.removeMovieClip();
				break;
			}
		}
	}
	function mergeCandidate():Void {
		//trace("mergeCandidate _zip = " + _zip);
		if (_zip.expanded) {
			for (var z = 0; z<_zips.length; z++) {
				var zip = _zips[z];
				if (_zip == zip || !zip.expanded()) {
					continue;
				}
				if (_zip.order == zip.order) {
					//trace(_zip._topBar + " ?hits? "+ zip._bottomBar);
					if (_zip._topBar.hitTest(zip._bottomBar)) {
						//trace("merge below");
						zip.mergeAbove(_zip);
					} else if (_zip._bottomBar.hitTest(zip._topBar)) {
						//trace("merge above");
						zip.mergeBelow(_zip);
					} else {
						//trace("no hit");
					}
				}
			}
		} else {
			trace("cannot merge collapsed zippers");
		}
	}
	function reDraw(iObj:Object):Void {
		_bar = Bar(attachMovie("Bar", "bar", 1));
		_value = iObj.initial.concat();
		_bar.init(_value, _iSize, 120, "Pad");
		var newWidth = _bar._width;
		_bar.onPress = _onPress;
		_bar.onRelease = _bar.onReleaseOutside=_onRelease;
		_bar._x = grow_btn._x+newWidth/2;
		_bar._y = grow_btn._y=shrink_btn._y=barOffset;
		for (var i = 0; i<_zips.length; i++) {
			_zips[i].setOrder(_value.length);
		}
	}
	function get iconSize():Number {
		return _iSize;
	}
	function show():Void {
		//trace("show: " + this);
		_visible = true;
	}
	function hide():Void {
		//trace("hide: " + this);
		_visible = false;
	}
	function getShuffle(value:Array):Object {
		return {order:value.length, type:"Generic"};
	}
	function reset():Void {
	}
	function play(shuffle:Object):Void {
	}
	function canPlay():Boolean {
		return false;
	}
	function readyToPlay():Boolean {
		return false;
	}
	function getSelectedZips():Array {
		var zips = new Array();
		for (var i = 0; i<_zips.length; i++) {
			var z = _zips[i];
			if (z.selected) {
				zips.push(z);
			}
		}
		trace("getSelectedZips().length="+zips.length);
		return zips;
	}
	function getAllZips():Array {
		trace("getAllZips().length="+_zips.length);
		return _zips.concat();
	}
	function update():Void {
		// do nothing
	}
}
