﻿class Bar extends MovieClip {
	// 
	// Top bars have an identity value.
	//
	// Bottom bars should have the same value as the complete transform
	//
	// Bars have icons which should be ordered according to the bar value.
	//
	var _order:Number;
	var _value:Array = [];
	var _icons:Array;
	var _iSize:Number;
	var _iScale:Number = 100;
	var _iName:String = "icon";
	var _iconsDraggable:Boolean = false;
	var _xStep:Number = 30;
	//	var _yStep:Number = 30;
	var _bar:MovieClip;
	static var _barHeight:Number = 8;
	static var _colours:Array = [0x1d32eb, 0x1ba3cf, 0xbdfdf7, 0xaba3fa];
	static var _alphas:Array = [100, 100, 100, 100];
	static var _ratios:Array = [0, 30, 70, 100];
	function Bar() {
	}
	function set value(a:Array) {
		_value = a.concat();
		reDraw();
	}
	function get value():Array {
		return _value.concat();
	}
	function get theBar():MovieClip {
		return _bar;
	}
	function get newValue():Array {
		var rv:Array = _value.concat();
		for (var i = _value.length-1; i>=0; i--) {
			for (var j = 0; j<i; j++) {
				//trace("rv["+j+"]="+rv[j]+"::rv["+(j+1)+"]="+rv[j+1]);
				if (_icons[rv[j]]._x>_icons[rv[j+1]]._x) {
					var tmp = rv[j];
					rv[j] = rv[j+1];
					rv[j+1] = tmp;
				}
			}
		}
		return Zipper.inverseValue(rv);
	}
	function set iconsDraggable(b:Boolean):Void {
		_iconsDraggable = b;
		draw();
	}
	function get icons():Array {
		return _icons;
	}
	function set numeric(b:Boolean):Void {
		for (var i = 0; i<_value.length; i++) {
			var icon = _icons[i];
			icon.gotoAndStop(b ? 2 : 1);
			icon._txt._x -= _iSize*0.6;
			icon._txt._width = _iSize*2;
			icon._txt.htmlText = (i+1);
		}
	}
	function reset() {
		for (var i = 0; i < _value.length; i++) {
			_icons[i].removeMovieClip();
		}
	}
	function init(perm:Array, iconSize:Number, iconScale:Number, iconBaseName:String):Void {
		_order = perm.length;
		_iSize = iconSize;
		_xStep = 2*iconSize;
		_iScale = iconScale;
		_icons = new Array();
		if (iconBaseName != undefined) {
			_iName = iconBaseName;
		} else {
			_iName = "icon";
		}
		_bar = this.createEmptyMovieClip("bar", 1);
		//_bar.menu = _parent.menu;
		//_bar.menu.onSelect(_parent.menuCallback);
		//trace(_bar.menu);
		_value = perm.concat();
		draw();
	}
	function setOrder(v:Number):Void {
		reset();
		for(var i = _value.length; i < v; i++) {
			_value[i] = i;
		}
		while(_value.length > v) {
			_value.pop();
		}
		init(_value, _iSize, _iScale, _iName);
	}
	function draw():Void {
		attachIcons(_value, _iName);
		drawBlueMetal(_bar, _order*_xStep);
	}
	function drawBlueMetal(mc:MovieClip, w:Number) {
		var h = _barHeight;
		var h2 = h/2;
		var w2 = w/2;
		mc.lineStyle(1, 0xffffff, 0);
		mc.beginGradientFill("linear", _colours, _alphas, _ratios, {matrixType:"box", x:0, y:-3.5*h2, w:w, h:16, r:-Math.PI/2});
		mc.moveTo(-w2, -h2);
		mc.lineTo(w2, -h2);
		mc.curveTo(w2+h2, -h2, w2+h2, 0);
		mc.curveTo(w2+h2, h2, w2, h2);
		mc.lineTo(-w2, h2);
		mc.curveTo(-w2-h2, h2, -w2-h2, 0);
		mc.curveTo(-w2-h2, -h2, -w2, -h2);
		mc.endFill();
	}
	function reDraw() {
		for (var i = 0; i<_value.length; i++) {
			_icons[i]._x = (2*_value[i]+1)*_iSize-_xStep*_order/2;
		}
	}
	function attachIcons(value:Array, iconBaseName:String) {
		for (var i = 0; i<value.length; i++) {
			_icons[i] = attachMovie(iconBaseName+(i%6), iconBaseName+i, 2+i, {_x:(2*_value[i]+1)*_iSize-_xStep*_order/2, _y:0});
			var icon = _icons[i];
			icon._xscale = _iScale;
			icon._yscale = _iScale;
			icon._index = i;
			icon.gotoAndStop(2);
			icon._txt._x -= _iSize*0.6;
			icon.gotoAndStop(1);
			if (_iconsDraggable) {
				icon.onPress = function() {
					if (_parent._parent.editable()) {
						var h = _parent._barHeight;
						var w = _parent._value.length*_parent._xStep;
						this.startDrag(false, -w/2, -h/2, w/2, h/2);
						_parent.startIconDrag(this, this._index);
					}
				};
				icon.onRelease = function() {
					if (_parent._parent.editable()) {
						this.stopDrag();
						_parent.stopIconDrag(this, this._index);
						for (var i = 0; i<_parent._icons.length; i++) {
							if (t == i) {
								continue;
							}
							var t = _parent._icons[i];
							if (hitTest(t)) {
								//trace(t);
								//trace(_parent._parent);
								break;
							}
						}
					}
				};
				icon.onReleaseOutside = icon.onRelease;
			}
		}
	}
	function startIconDrag(icon:MovieClip, index:Number) {
		_parent.startIconDrag(icon, index);
	}
	function stopIconDrag(icon:MovieClip, index:Number) {
		_parent.stopIconDrag(icon, index);
	}
	function setIconVisibility(b:Boolean) {
		for (var i = 0; i<_value.length; i++) {
			_icons[i]._visible = b;
		}
	}
	function hideIcons() {
		setIconVisibility(false);
	}
	function showIcons() {
		setIconVisibility(true);
	}
	function showBar() {
		_bar._visible = true;
	}
	function hideBar() {
		_bar._visible = false;
	}
}
