﻿import it.sephiroth.iTreeDnd
import mx.events.EventDispatcher
import mx.core.UIComponent


[Event("double_click")]
[Event("drag_start")]
[Event("drag_complete")]
[Event("drag_fail")]



/**
 * @class it.sephiroth.TreeDnd
 * Drag and Drop extension for mx.controls.Tree macromedia components
 * It allow to define different rules for dragging items and folder 
 * into a Tree component
 * 
 * @author	alessandro crugnola
 * @version	1.1.0
 * @return		
 */
class it.sephiroth.TreeDnd extends UIComponent implements iTreeDnd
{
	// define component specific variables
	private var symbolName:String  = "TreeDnd"
	private var symbolOwner:Object = TreeDnd
	private var className:String   = "TreeDnd"
	
	// define private variables
	private var label:MovieClip
	private var tree:mx.controls.Tree
	private var icon:MovieClip
	private var tree_listener:Object
	private var controller_mc:MovieClip
	private var boundingBox_mc:MovieClip
	private var tfList:Object
	private var _iconFunction:Function
	
	private var TREEDEPTH:Number = 10
	private var CONTDEPTH:Number = 11
	private var ICONDEPTH:Number = 12
	
	var addEventListener:Function
	var removeEventListener:Function
	var dispatchEvent:Function
	
	static var DENYDRAGFOLDER:Number      = 1
	static var DENYDRAGITEM:Number        = 2
	static var DENYDROPITEM:Number        = 4
	static var DEFAULT:Number             = 0
	static var DENYALL:Number             = DENYDRAGITEM | DENYDRAGFOLDER | DENYDROPITEM
	
	private var __options:Number = DEFAULT
	

	/**
	 * constructor
	 * 
	 * @return		
	 */
	function TreeDnd()
	{
	}
	
	// ******************************************
	// Private methods
	// ******************************************
	

	/**
	 * Override the UIComponent init() method
	 * 
	 * @return		
	 */
	private function init():Void
	{
		super.init();
		var width  = __width
		var height = __height		
		__options = DEFAULT
		boundingBox_mc._visible = false
		boundingBox_mc._width = boundingBox_mc._height = 0;
		// create the objects to be used in the component
		createClassObject(mx.controls.Tree, "tree", TREEDEPTH, {_width : width, _height : height})
		controller_mc = createEmptyObject("controller_mc", CONTDEPTH);
		// initialize the event object
		EventDispatcher.initialize( this );
		initTreeListener();
	}
	
	/**
	 * 
	 * @param	Void	
	 * @return		
	 */
	function size(Void) : Void
	{
		super.size();
		tree.setSize( __width, __height, true );
	}
	
	/**
	 * 
	 * 
	 * @param	Void	
	 * @return		
	 */
	function draw(Void):Void{
		super.draw();
	}
	
	/**
	 * Initialize Tree listeners and Tree MovieClip controllers
	 * 
	 * @return		
	 */
	private function initTreeListener():Void
	{
		// Tree listeners
		tfList = new Object();
		tfList.selectedItem  = undefined
		tfList.selectedIndex = undefined
		tfList._parent = this
		tfList._time = getTimer();
		tfList._oldItem = undefined
		// tree itemRollOver
		tfList.itemRollOver = function( evt ){
			var item = this._parent.tree.getItemAt(evt.index)
			if( item != undefined )
			{
				var opt:Number   = this._parent.dragRules
				//trace('is branch? ' + this._parent.tree.getIsBranch( item ))
				//trace('options: ' + opt)
				//trace(DENYDRAGITEM)
				trace
				if( (opt == DENYDRAGFOLDER  or opt == (DENYDRAGFOLDER | DENYDROPITEM) or opt == (DENYDRAGITEM | DENYDRAGFOLDER) or opt == DENYALL) and this._parent.tree.getIsBranch( item ))
				{
					this.itemRollOut()
					//trace('DENY DRAG FOLDER')
					return
				} else if( !this._parent.tree.getIsBranch( item ) and (opt == DENYDRAGITEM or opt == DENYALL or opt == (DENYDRAGITEM | DENYDROPITEM) or opt == (DENYDRAGITEM | DENYDRAGFOLDER)))
				{
					//trace('DENY DRAG ITEM')
					this.itemRollOut()
					return
				}
				this.selectedItem  = item
				this.selectedIndex = evt.index
			} else {
				this.itemRollOut();
			}
		}
		
		// tree itemRollOut
		tfList.itemRollOut = function(evt:Object)
		{
			this.selectedItem  = undefined
			this.selectedIndex = undefined
		}
		
		tfList.change = function( evt:Object)
		{
			if( (getTimer() - this._time) < 300)
			{
				if( evt.target.selectedItem == this._oldItem)
				{
					this._parent.dispatchEvent({type:"double_click", target: this._parent.tree});
				}
			}
			this._oldItem = evt.target.selectedItem
			this._time = getTimer()
		}
		
		// add tree listeners
		tree.addEventListener("change",       tfList)
		tree.addEventListener("itemRollOver", tfList)
		tree.addEventListener("itemRollOut",  tfList)

		// controller functions
		controller_mc.tree  = tree
		controller_mc.item  = undefined
		controller_mc.index = undefined
		controller_mc.__canDrop   = false
		controller_mc.__dropIndex = undefined
		controller_mc.__targetNode  = undefined
		controller_mc.__dragStart   = false
		controller_mc.onMouseDown = function(){
			this.__dragStart = false
			this.item  = this._parent.tfList.selectedItem
			this.index = this._parent.tfList.selectedIndex
			this.added = false
			this.__targetNode = undefined
			this.points = new Array( this._xmouse, this._ymouse);
			if( this.item == undefined ){
				return;
			}
			this.onEnterFrame = function(){
				/**
				 * canDrop:
				 * -1 => deny always
				 *  0  => deny if dropIndex == undefined
				 *  1  => allow
				 */
				this.clear();
				var canDrop:Number      = -1
				var dropIndex:Number    = undefined
				var opt:Number          = this._parent.dragRules
				var targetLabel:Boolean = false
				var default_icon:String
				if( !this.added ){
					var x = this._xmouse
					var y = this._ymouse
					if(Math.abs( x  - this.points[0] ) > 2 or Math.abs( y - this.points[1] ) > 2 ){
						if( !this.added and this.item != undefined ){
							this.__dragStart = true
							this.added = true
							this._parent.createIcon( )
							this._parent.dispatchEvent({type:"drag_start", target:this.tree, sourceNode: this.item});
						}
					}
				} else {
					for(var a = 0; a < this.tree.rows.length; a++)
					{
						if( this.tree.rows[a].item != undefined)
						{
							if( this.tree.rows[a].hitTest( this._parent._parent._xmouse, this._parent._parent._ymouse, true) )
							{
								var item = this.tree.rows[a]
								this.__targetNode = item
								if( item.item == this.item ){
									// if the same item, then DENY
									canDrop = 0;
								} else if ( this._parent.isSubNode(this.item , item.item ) ){
									// If trying to DROP an item inside itself, DENY
									canDrop = -1;
								} else {
									canDrop = 1;
									// now core functions..
									// check if item can be dropped and where it will be dropped!
									// deny drop into item 3,4,5,6,7
									if( (opt >= (DENYDRAGITEM | DENYDRAGFOLDER) and opt <= DENYALL) and !this.tree.getIsBranch( item.node )){
										if( opt == DENYALL ){
											canDrop = -1
										} else {
											canDrop = 0;
										}
									}
								}
								if( item._ymouse > ((item.bG_mc._height/2) + item.bG_mc._height/4))
								{
									this.beginFill(0x666666,100)
									this.drawRect( 0, item._y + item.bG_mc._height, this._parent.tree.width - this._parent.tree.vSB.width - 1, item._y + item.bG_mc._height + 1 )
									this.endFill();
									// try to retrieve the item index
									if( this.tree.getIsBranch( item.node ) )
									{
										if( this.tree.getIsOpen( item.node ))
										{
											// it's the first element of the branch
											dropIndex = item.rowIndex
										}
									}
									dropIndex = item.rowIndex
								}
								break;
							}
						}
					}
					// Now apply permissions to dragging icon
					if( canDrop == 1 )
					{
						targetLabel = true
						this.__canDrop = true
					} else if(canDrop == 0)
					{
						if(dropIndex == undefined)
						{
							targetLabel = false
							this.__canDrop = false
						} else {
							targetLabel = true
							this.__canDrop = true
						}
					} else {
						targetLabel = false
						this.__canDrop = false
					}
					this.__dropIndex = dropIndex
					default_icon = this._parent._iconFunction( targetLabel )
					if( default_icon == undefined )
					{
						default_icon = targetLabel ? "icon_allow_drag" : "icon_deny_drag"
					}					
					if( this._parent.icon[default_icon]._name != default_icon or this._parent.icon[default_icon] == undefined)
					{
						this._parent.icon.attachMovie( default_icon, default_icon , 1 )
					}
				}
				
				var _mouseP = new Object();
				_mouseP.x = this._parent._parent._xmouse
				_mouseP.y = this._parent._parent._ymouse
				this._parent.globalToLocal( _mouseP )
				this._parent.icon._x = _mouseP.x + 5
				this._parent.icon._y = _mouseP.y + 15
			}
			this.onEnterFrame();
		}
		
		/**
		* mouse up, drag and drop end
		*/
		controller_mc.onMouseUp = function(){
			delete this.onEnterFrame
			if( this.__dragStart != true ){
				return;
			}
			if( this.__canDrop == true )
			{
				var node = this.tree.getItemAt(this.index)
				if( this.__dropIndex != undefined )
				{
					if( this.tree.getIsBranch( this.__targetNode.item ) and this.tree.getIsOpen( this.__targetNode.item ))
					{
						this.__targetNode.item.addTreeNodeAt(0, node )
					} else {
						if(this.__targetNode.item.nextSibling == null)
						{
							this.__targetNode.item.parentNode.addTreeNode( node )
						} else {
							if( node != this.__targetNode.item )
							{
								node.removeNode()
								this.__targetNode.item.parentNode.insertBefore( node, this.__targetNode.item.nextSibling )
							}
						}
					}
				} else {
					this.__targetNode.item.addTreeNode( node )
				}
				this._parent.dispatchEvent({type:"drag_complete", target: this.tree, sourceNode: node, targetNode: this.__targetNode.item})
				this.tree.dataProvider = this.tree.getDataProvider()
			} else {
				this._parent.dispatchEvent({type:"drag_fail", target: this.tree, sourceNode: node, targetNode: this.__targetNode.item})
			}
			this.clear();
			this.__canDrop   = false
			this.__dropIndex = undefined
			this._parent.removeIcon()
			this.points = new Array();
			this.item   = undefined
			this.index  = undefined
			this.added  = false
			
		}
	}
	
	/**
	 * Remove Dragged icon
	 * 
	 * @return		
	 */
	private function removeIcon():Void
	{
		icon.removeMovieClip();
	}
	
	/**
	 * Create the Dragged icon
	 * 
	 * @return		
	 */
	private function createIcon():MovieClip
	{
		return createEmptyObject( "icon", ICONDEPTH );
	}
	
	/**
	 * Verify that targetNode is a subnode of dragNode
	 * 
	 * @param	dragNode	
	 * @param	targetNode	
	 * @return		
	 */
	private function isSubNode( dragNode:XMLNode, targetNode:XMLNode):Boolean
	{
		var ret:Boolean = false;
		while( targetNode.parentNode != undefined)
		{
			if(targetNode == dragNode)
			{
				ret = true;
				break;
			}
			targetNode = targetNode.parentNode
		}
		return ret;
	}
	
	
	// ******************************************
	// Getter / Setter
	// ******************************************
	
	[Inspectable(defaultValue=0,type=Number)]
	public function set dragRules(value:Number)
	{
		if(value >= 0 and value <= DENYALL and value != undefined)
		{
			__options = value
		} else {
			throw new Error("IndexError: value must be an integer between " + DEFAULT + " and " + DENYALL);
		}
		/**
		0 DEFAULT -> Allow everything
		1 DENYDRAGFOLDER -> DENY drag folders
		2 DENYDRAGITEM   -> DENY drag items
		4 DENYDROPITEM   -> DENY drop into items
		5 DENYDRAGFOLDER | DENYDROPITEM -> Deny Drag folder & deny drop on items
		6 DENYDRAGITEM | DENYDROPITEM   -> Deny drag item & deny drop item
		7 DENYALL -> Deny All
		3 DENYDRAGITEM | DENYDRAGFOLDER -> Deny All
		*/
		//trace('drag: ' + __options)
	}
	
	public function get dragRules():Number
	{
		return __options
	}
	
	// set icon function for display allow/deny dragging icon
	public function set iconFunction(func:Function)
	{
		_iconFunction = func
	}
	
	public function get iconFunction():Function
	{
		return _iconFunction
	}
	
	// ******************************************
	// Tree public functions
	// ******************************************
	
	/**
	 * Give a pointer to the current used Tree component
	 * 
	 * @return		
	 */
	public function getTree():mx.controls.Tree
	{
		return this.tree
	}
	
}