﻿//import mx.styles.CSSStyleDeclaration;
//import mx.controls.listclasses.DataProvider;
class Zipper extends MovieClip {
	var _idle:Boolean = true;
	var _initialValue:Array;
	var _value:Array;
	var _penultimateValue:Array;
	var values:Array;
	var labels:Array;
	var label:String;
	var _order:Number = 3;
	var _t:Number = 1;
	var _d:Number = 0;
	var _tStep = 0.05;
	var _topBar:Bar;
	var _bottomBar:Bar;
	var _link:Array = null;
	var _iSize:Number = 20;
	var _xStep:Number = 40;
	var _yStep:Number = 40;
	var _dragIcon:MovieClip = null;
	var _dragIconIndex:Number = null;
	var _dragBar:Bar;
	var _barWidth;
	var _savedIcons:Array;
	var _savedIconsX:Array;
	var menu_btn:MovieClip;
	//var collapse_btn:MovieClip;
	//var expand_btn:MovieClip;
	var label_btn:MovieClip;
	var value_btn:MovieClip;
	var close_btn:MovieClip;
	var rewind_btn:MovieClip;
	var play_btn:MovieClip;
	var _shuffle:Object;
	//	var menu:mx.controls.Menu;
	var minimise_item;
	var maximise_item;
	var _selected:Boolean = false;
	var highlight:MovieClip;
	var color:Color;
	static var colorT0:Object;
	static var colorT1:Object;
	var isZipSet:Boolean = false;
	function Zipper() {
	}
	function get shuffle():Object {
		return _shuffle;
	}
	function set shuffle(s:Object):Void {
		_shuffle = s;
	}
	function set selected(b:Boolean):Void {
		_selected = b;
		if (b) {
			color.setTransform(colorT1);
		} else {
			color.setTransform(colorT0);
		}
	}
	function get selected():Boolean {
		return _selected;
	}
	function get draggableBar():MovieClip {
		return _topBar.theBar;
	}
	function identityInit() {
		_initialValue = new Array();
		for (var i = 0; i<_order; i++) {
			_initialValue[i] = i;
		}
	}
	function labelChanged(i:Number, s:String) {
		//trace("Label["+i+"] changed to "+s);
		labels[i] = s;
	}
	function init(value:Array, iconSize:Number, editable) {
		if (color == undefined) {
			color = new Color(this);
			if (colorT0 == null) {
				colorT0 = new Object();
				colorT0 = color.getTransform(this);
				colorT1 = new Object();
				for (var prop in colorT0) {
					colorT1[prop] = colorT0[prop];
				}
				colorT1.rb = 120;
			}
		}
		_level0.popupMenu.setMenuItemSelected(_level0.popupMenu["edit"], editable);
		// WORKS IF COMMENTED FROM HERE
		/*
												if (_global.styles.Menu == undefined) {
													_global.styles.Menu = new CSSStyleDeclaration();
													var source = _global.styles.ScrollSelectList;
													var target = _global.styles.Menu;
													for (var style in source) {
														target.setStyle(style, source.getStyle(style));
													}
													_global.styles.Menu.setStyle("backgroundColor", 0xFFFFFF);
													_global.styles.Menu.setStyle("themeColor", "haloBlue");
												}
												*/
		//* STILL FAILS IF FOLLOWING REMOVED
		// 
		// other inits
		//
		_value = value.concat();
		values = new Array();
		labels = new Array();
		values.push(_value);
		_order = _value.length;
		identityInit();
		_iSize = iconSize;
		_xStep = _iSize*2;
		_yStep = _iSize*3;
		// Add first sorter
		_link = new Array();
		_link[0] = Sorter(attachMovie("Sorter", "link0", 10));
		_link[0].init(_value, 0, "Dot", _iSize, _xStep, _yStep, 2, 0xffcc33, 100, "e");
		_link[0].initialValue = _initialValue;
		// Add top bar
		_topBar = Bar(attachMovie("Bar", "topBar", 30));
		_topBar.init(_initialValue, _iSize, 120, "Pad");
		_topBar.iconsDraggable = false;
		// Add bottom bar
		_bottomBar = Bar(attachMovie("Bar", "bottomBar", 40));
		_bottomBar.init(_value, _iSize, 100, "icon");
		_bottomBar._y += _yStep*_link.length;
		_bottomBar.iconsDraggable = true;
		// Save barwidth
		_barWidth = _topBar._width;
		// Add close button
		close_btn = attachMovie("Close_btn", "close_btn", 50);
		close_btn._x += _barWidth/2;
		menu_btn = attachMovie("Menu_btn", "menu_btn", 60);
		menu_btn._x -= _barWidth/2;
		value_btn = attachMovie("Value_btn", "value_btn", 72);
		value_btn._x -= _barWidth/2;
		value_btn._visible = false;
		rewind_btn = attachMovie("Rewind_btn", "rewind_btn", 80);
		rewind_btn._x -= _barWidth/2;
		rewind_btn._y += _yStep;
		play_btn = attachMovie("Play_btn", "play_btn", 90);
		play_btn._x += _barWidth/2;
		play_btn._y += _yStep;
		//
		// Add button behaviours
		//
		close_btn.onRelease = function() {
			//trace(_parent._parent);
			_parent._parent.deleteZip(_parent);
		};
		menu_btn.onPress = function() {
			var menu = _level0.popupMenu;
			var stage = _global.window;
			var scale = _parent._parent._xscale/100;
			//var menu = _parent.menu;
			// Calculate menu location
			// trace(_global.window._height+" :: "+ _global.window._width);
			var mx = _parent._parent._x+(_parent._x-_parent._width/2)*scale+menu.width/2+_width;
			var my = (_parent._y)*scale-_height;
			if (mx+menu.width>stage._width) {
				mx = stage._width-menu.width-10;
				// (_parent._width*scale+_width);
			}
			if (my+menu.height>stage._height) {
				my = stage._height-menu.height-10;
				// _parent._height;
			}
			//trace("mx:" + mx + " mw:"+menu.width + " sw:"+stage._width);
			menu.show(mx, my);
			//enabled = false;
			_global.freezeSelection = true;
			_global.menuPressedZip = _parent;
			// trace(_parent.menu.x+","+_parent.menu.y+","+_parent.menu.width+","+_parent.menu.height);
		};
		rewind_btn.onRelease = function() {
			if (!_parent._idle) {
				return;
			}
			_parent._idle = false;
			_parent.reduce();
		};
		play_btn.onRelease = function() {
			if (!_parent._idle) {
				return;
			}
			_parent._idle = false;
			_parent._t = 0;
			_parent._d = 0;
			_parent.rewind();
			_parent._savedIcons = _parent._bottomBar._icons.concat();
			for (var i = 0; i<_parent._value.length; i++) {
				_parent._savedIconsX[i] = _parent.savedIcons[i]._x;
			}
			_parent.onEnterFrame = _parent.play;
			//_parent._parent.play(_parent._shuffle);
		};
		_topBar.onRollOver = _topBar.onRollOut=function () {
			var m = _level0.popupMenu;
			var mitem = m["edit"];
			m.setMenuItemSelected(mitem, !mitem.attributes.selected);
			_parent.showIfEditable();
		};
		_topBar.onPress = function() {
			// trace(_parent);
			_parent.selected = true;
			//trace(_parent._parent);
			Mouse.removeListener(_parent._parent);
			_parent.startDrag();
		};
		_topBar.onReleaseOutside = _topBar.onRelease=function () {
			_parent.stopDrag();
			_parent._parent._zip = _parent;
			_parent._parent.mergeCandidate();
		};
	}
	function editable():Boolean {
		return Boolean(_level0.popupMenu["edit"].attributes.selected);
	}
	function showIfEditable() {
		if (editable()) {
			showValue();
		} else {
			hideValue();
		}
	}
	function showValue():Void {
		//trace("edit");
		for (var i = 0; i<_link.length; ++i) {
			_link[i].showCycleString(cycleStringChanged);
		}
	}
	function hideValue():Void {
		//trace("hideValue");
		for (var i = 0; i<_link.length; ++i) {
			_link[i].hideCycleString();
		}
	}
	// Menu changed event handler
	function change(event) {
		var item = event.menuItem;
		var menu = event.menu;
		trace("Item selected: "+item.attributes.label+" this="+this);
		//this = zip
		_global.freezeSelection = false;
		switch (item.attributes.instanceName) {
		case "clone" :
			var clone = _parent.cloneZip(this);
			clone._x = _x+20;
			clone._y = _y+20;
			break;
		case "edit" :
			showIfEditable();
			break;
		case "inverse" :
			inverse();
			break;
		case "save" :
			saveAsPopup();
			break;
		default :
			_parent.deleteZip(this);
		}
	}
	function inverse():Void {
		var clone = _parent.cloneZip(this);
		clone.values[0] = clone._value=inverseValue(_value);
		clone._x = _x+20;
		clone._y = _y+20;
		clone.reDraw(0);
	}
	function saveAsPopup() {
		var myWindow = mx.managers.PopUpManager.createPopUp(_level0, mx.containers.Window, true, {title:"Save Shuffles", contentPath:"saveAsPopup", closeButton:true});
		var closeListener:Object = new Object();
		var w = 348;
		var h = 320;
		myWindow.setSize(w, h);
		myWindow._alpha = 100;
		myWindow._x = (_global.window._width-w)/2;
		myWindow._y = (_global.window._height-h)/2;
		myWindow.zip = this;
		_global.freezeSelection = true;
		closeListener.click = function(evt) {
			_global.freezeSelection = false;
			evt.target.deletePopUp();
		};
		myWindow.addEventListener("click", closeListener);
	}
	// Menu hidden handler
	function hide(event) {
		menu_btn.enabled = true;
	}
	function reDraw(n:Number) {
		//trace("reDraw");
		revalue();
		//trace("value = "+_value);
		_order = _value.length;
		identityInit();
		// Add sorters
		for (var i = 0; i<values.length; i++) {
			_link[i] = Sorter(attachMovie("Sorter", "link"+i, 10+i));
			_link[i].init(values[i], i, "Dot", _iSize, _xStep, _yStep, 2, 0xffcc33, 100, labels[i]);
		}
		var step = n*_yStep;
		_bottomBar._y += step;
		_bottomBar.value = _value;
		rewind_btn._y += step;
		play_btn._y += step;
		showIfEditable();
	}
	function setOrder(v:Number):Void {
		for (var i = _value.length; i<v; i++) {
			_value[i] = i;
		}
		while (_value.length>v) {
			_value.pop();
		}
		_order = _value.length;
		for (var j = 0; j<values.length; j++) {
			var val = values[j];
			for (var i = val.length; i<v; i++) {
				val[i] = i;
			}
			while (val.length>v) {
				val.pop();
			}
		}
		_topBar.setOrder(_order);
		_bottomBar.setOrder(_order);
		_barWidth = _topBar._width;
		// Add close button
		close_btn._x = _barWidth/2;
		menu_btn._x = -_barWidth/2;
		value_btn._x = -_barWidth/2;
		rewind_btn._x = -_barWidth/2;
		play_btn._x = _barWidth/2;
		for (var i = 0; i<values.length; i++) {
			_link[i] = Sorter(attachMovie("Sorter", "link"+i, 10+i));
			_link[i].init(values[i], i, "Dot", _iSize, _xStep, _yStep, 2, 0xffcc33, 100, labels[i]);
		}
	}
	function get order() {
		return _value.length;
	}
	function minOrder():Number {
		var m = 1;
		for (var i = 0; i<values.length; i++) {
			m = Math.max(minValueOrder(values[i]), m);
		}
		return m;
	}
	static function minValueOrder(v:Array):Number {
		var m = v.length;
		while (v[m-1] == (m-1) && m>0) {
			m--;
		}
		//trace("minOrder = "+m);
		return m;
	}
	function get depth() {
		return _link.length;
	}
	// animated reduction to one-stage
	var _u = 0;
	var _newLastLink:Sorter;
	var _newLastValue:Array;
	var _newLastIndex:Number;
	var _midKnots:MidKnots;
	function reduce() {
		if (_link.length<2) {
			rewind();
			_idle = true;
			return;
		}
		_u = 0;
		_t = 0;
		_newLastIndex = _link.length-2;
		var lastLink = _link[_newLastIndex+1];
		var penultimate = _link[_newLastIndex];
		//trace("newLastIndex="+_newLastIndex+" pen.value="+penultimate.value+" pen.depth="+penultimate.getDepth()+" last="+lastLink);
		_newLastValue = compose(lastLink.value, penultimate.value);
		_newLastLink = Sorter(attachMovie("Sorter", "nlink", _root.getNextHighestDepth()));
		//trace("newly created link depth is "+_newLastLink.getDepth());
		//		_newLastLink = Sorter(attachMovie("Sorter", "link"+_newLastIndex, 10+_newLastIndex));
		_newLastLink.init(_newLastValue, _newLastIndex, "Dot", _iSize, _xStep, _yStep, 2, 0xffcc33, 100, labels[_newLastIndex]+labels[_newLastIndex+1]);
		//_newLastLink.initLabel(labels[_newLastIndex]+labels[_newLastIndex+1], labelChanged);
		_newLastLink._alpha = 0;
		//_newLastLink._x -= _xStep*_order/2;
		//_newLastLink._y -= _iSize-(_newLastIndex)*_yStep;
		_midKnots = new MidKnots(_newLastLink, penultimate, lastLink);
		onEnterFrame = function () {
			if (_u<1.05) {
				var yinc = _yStep/20;
				_midKnots.interpolate(_u, _link[_newLastIndex], _link[_newLastIndex+1]);
				if (_u>0) {
					_bottomBar._y -= yinc;
					rewind_btn._y -= yinc;
					play_btn._y -= yinc;
					_link[_link.length-1]._y -= yinc;
				}
				_u += 0.05;
			} else {
				// init(_value, _iSize);
				var v = values[_newLastIndex]=_newLastValue;
				// trace("_value = "+v);
				values.pop();
				labels[_newLastIndex] = labels[_newLastIndex]+labels[_newLastIndex+1];
				// trace(labels[_newLastIndex]);
				labels.pop();
				_newLastLink.label = labels[_newLastIndex];
				// trace("swapped old="+_link[_newLastIndex].getDepth()+" new="+_newLastLink.getDepth());
				_link[_newLastIndex].swapDepths(_newLastLink);
				// trace("swapped old="+_link[_newLastIndex].getDepth()+" new="+_newLastLink.getDepth());
				_link[_newLastIndex+1].unloadMovie();
				_link[_newLastIndex].unloadMovie();
				_link[_newLastIndex] = _newLastLink;
				// trace("swapped old="+_link[_newLastIndex].getDepth());
				_newLastLink.value = v;
				_newLastLink._alpha = 100;
				_newLastLink._name = "link"+(10+_newLastIndex);
				this[_newLastLink._name] = _newLastLink;
				// trace("prepop link length = "+_link.length);
				_link.pop();
				onEnterFrame = undefined;
				// enable the following to reduce completely
				// if (_link.length>1) {
				// reduce();
				// } else {
				_idle = true;
				// }
				_t = 1;
				showIfEditable();
			}
		};
	}
	function rewind() {
		_t = 0;
		_d = 0;
		for (var p = 0; p<_value.length; p++) {
			var icon = _bottomBar.icons[p];
			_bottomBar.icons[p]._x = _topBar.icons[p]._x;
			_bottomBar.icons[p]._y = -yStep*_link.length;
		}
	}
	function play() {
		var link = _link[_d];
		if (_t == 0) {
			_parent.reset();
		}
		for (var p = 0; p<_value.length; ++p) {
			var loc:Object = link.iconLocationAtFrame(p, _t);
			var icon = _bottomBar.icons[p];
			icon._x = loc._x-(_xStep*_value.length)/2;
			icon._y = loc._y-_iSize-_yStep*(_link.length-_d);
			//trace("rotation="+loc._rotation);
			icon._rotation = loc._rotation;
		}
		if (_t == _tStep) {
			//trace(link.value);
			//Play any factory animation
			if (_parent.canPlay()) {
				if (_parent.readyToPlay()) {
					_parent.play(_parent.getShuffle(link.value));
				} else {
					return;
				}
			}
		}
		if (_t>1) {
			_t = _tStep;
			if (_d<_link.length) {
				//trace(_d);
				//_d++;
				// swap bottom bar icons
				//var inv = inverse(link._value);
				var _bIcons:Array = _bottomBar.icons.concat();
				for (var i = 0; i<_value.length; i++) {
					_bottomBar.icons[link._value[i]] = _bIcons[i];
				}
				if (++_d == _link.length) {
					_d = 0;
					_bottomBar._icons = _savedIcons;
					_idle = true;
					onEnterFrame = undefined;
				}
			}
		} else {
			_t += _tStep;
		}
	}
	static function inverseValue(v:Array):Array {
		var inv = new Array();
		for (var i = 0; i<v.length; i++) {
			inv[v[i]] = i;
		}
		//trace("inverse of "+v+" is "+inv);
		return inv;
	}
	function set yStep(s:Number):Void {
		_yStep = s;
		for (var i = 0; i<_link.length; i++) {
			var link = _link[i].yStep=s;
			var offset = i*s;
			link._y = offset-_iSize;
			_topBar._y = offset;
			_bottomBar._y = expanded() ? offset+s : offset;
		}
	}
	function get yStep():Number {
		return _yStep;
	}
	function startIconDrag(icon:MovieClip, index:Number) {
		var barType:String;
		_dragIconIndex = index;
		//trace("dragIcon = "+_dragIconIndex);
		_dragIcon = icon;
		if (icon.hitTest(_bottomBar)) {
			_dragBar = _bottomBar;
			_penultimateValue = penultimate();
			onEnterFrame = function () {
				var lastLink = _link[_link.length-1];
				lastLink.moveBottom(_penultimateValue[_dragIconIndex], _dragIcon._x);
			};
		} else {
			_dragBar = null;
		}
	}
	function penultimate():Array {
		var lastLink = _link[_link.length-1];
		var invLastValue:Array = inverseValue(lastLink.value);
		var rv:Array = new Array();
		for (var i = 0; i<_value.length; i++) {
			rv[i] = invLastValue[_value[i]];
		}
		return rv;
	}
	static function compose(v2:Array, v1:Array):Array {
		var rv:Array = new Array();
		for (var i = 0; i<v1.length; i++) {
			rv[i] = v2[v1[i]];
		}
		return rv;
	}
	function stopIconDrag(icon:MovieClip, index:Number) {
		onEnterFrame = null;
		_dragIcon = null;
		_dragIconIndex = null;
		var value = _dragBar.newValue;
		//trace("bottom Bar Value = "+value);
		if (_dragBar == _bottomBar) {
			// Dragging the bottom bar changes the shuffle
			var lastLink:Array = _link[_link.length-1];
			var newLast:Array = compose(value, inverseValue(_penultimateValue));
			values[_link.length-1] = lastLink.value=newLast;
			_bottomBar.value = value;
		}
		revalue();
	}
	function revalue():Void {
		var v = new Array();
		for (var j = 0; j<_value.length; j++) {
			v[j] = j;
		}
		//trace(values.length);
		for (var i = 0; i<values.length; i++) {
			//trace("values["+i+"]="+values[i].value);
			for (var j = 0; j<_value.length; j++) {
				//v[j] = values[i].value[v[j]];
				v[j] = values[i][v[j]];
			}
		}
		_value = v;
		showIfEditable();
		//trace("revalue: "+_value);
	}
	function expanded() {
		return _bottomBar._y>_topBar._y+_yStep/2;
	}
	function expand() {
		//trace("expand " + _bottomBar + ":" + _topBar)
		_bottomBar._y = _topBar._y+_yStep*_link.length;
		_bottomBar.numeric = false;
		_bottomBar.showBar();
		setLinkVisibility(true);
		play_btn._visible = true;
		rewind_btn._visible = true;
		//expand_btn._visible = false;
		//collapse_btn._visible = true;
		for (var i = 0; i<_link.length; ++i) {
			_link[i].labelVisibility = true;
		}
	}
	function contract() {
		//trace(_t);
		if (_t>0.0001) {
			_bottomBar._y = _topBar._y;
		}
		_bottomBar.hideBar();
		_bottomBar.numeric = false;
		setLinkVisibility(false);
		play_btn._visible = false;
		rewind_btn._visible = false;
		//expand_btn._visible = true;
		//collapse_btn._visible = false;
		for (var i = 0; i<_link.length; ++i) {
			_link[i].labelVisibility = true;
		}
	}
	function labelView() {
		for (var i = 0; i<_link.length; ++i) {
			_link[i].labelVisibility = true;
		}
		label_btn._visible = false;
		value_btn._visible = true;
	}
	function valueView() {
		for (var i = 0; i<_link.length; ++i) {
			_link[i].labelVisibility = false;
		}
		value_btn._visible = false;
		//expand_btn._visible = true;
	}
	static function cycleString(value:Array):String {
		var todo:Array = new Array();
		todo.indexOf = function(v:Number) {
			for (var i = 0; i<todo.length; i++) {
				if (todo[i] == v) {
					return i;
				}
			}
			return -1;
		};
		for (var i = 0; i<value.length; i++) {
			todo[i] = i;
		}
		var s = "";
		while (todo.length>0) {
			var n = todo.shift();
			var v = value[n];
			if (v == n) {
				continue;
			} else {
				// start building a cycle
				var cycle = "("+(n+1);
				while (todo.length>0) {
					n = todo.indexOf(v);
					if (n>=0) {
						todo.splice(n, 1);
						cycle += " "+(v+1);
						v = value[v];
					} else {
						break;
					}
				}
				// finish building the cycle
				cycle += ")";
				// add cycle to s
				s += cycle;
			}
		}
		if (s == "") {
			s = "(1)";
		}
		return s;
	}
	function cycleStringChanged(changed_txt:TextField) {
		trace("changed to"+changed_txt.text);
	}
	function setLinkVisibility(b:Boolean) {
		for (var i = 0; i<_link.length; i++) {
			_link[i]._visible = b;
		}
	}
	function mergeLeft(zip:Zipper) {
	}
	function mergeAbove(zip:Zipper) {
		if (isZipSet) {
			trace("isZipSet above WORKS");
		}
		if (zip.isZipSet) {
			trace("zip.isZipSet above FAILS");
			// fails by not copying the ZipSet
		}
		if (_idle) {
			//trace("above");
			//values.push({value:zip._value});
			//trace("values.length="+values.length+" zip.length="+zip.values.length);
			values = values.concat(zip.values);
			labels = labels.concat(zip.labels);
			//zip.initialValue = _value;
			reDraw(zip.values.length);
		}
		//zip.unloadMovie();
	}
	function mergeBelow(zip:Zipper) {
		if (isZipSet) {
			trace("isZipSet below FAILS");
			// this fails by always making index[0] the ZipSet
		}
		if (zip.isZipSet) {
			trace("zip.isZipSet below FAILS");
			// fails by not copying the ZipSet
		}
		if (_idle) {
			values = zip.values.concat(values);
			labels = zip.labels.concat(labels);
			_y -= _yStep*zip.depth;
			reDraw(zip.values.length);
		}
	}
	function set initialValue(v:Array):Void {
		_initialValue = _value;
		_link[0].initialValue = _value;
	}
	function get zipValue():Array {
		return _value;
	}
	function get iconSize():Number {
		return _iSize;
	}
}
