﻿class Sorter extends MovieClip {
	//
	// A Sorter is a single stage permutation.
	//
	var _xStep:Number = 100;
	var _yStep:Number = 100;
	var _dotId:String = "Dot";
	var _lineWidth:Number = 5;
	var _lineColour:Number = 0x888888;
	var _lineAlpha:Number = 100;
	var _pathDepth:Number = 0;
	var _initialValue:Array;
	var _value:Array;
	var _tops:Array;
	var _topCtls:Array;
	var _bottoms:Array;
	var _bottomCtls:Array;
	var _paths:Array;
	var lineCount = 20;
	var _w:Number;
	var _index:Number = 0;
	static var _bDepth = 10;
	function Sorter() {
	}
	function dotName(xinc:Number, yinc:Number) {
		return _name+"("+xinc+","+yinc+")";
	}
	function init(perm:Array, index:Number, dotId:String, iSize:Number, xStep:Number, yStep:Number, lineWidth:Number, lineColour:Number, lineAlpha:Number, label:String) {
		_dotId = dotId;
		_xStep = xStep;
		_yStep = yStep;
		_lineWidth = lineWidth;
		_lineColour = lineColour;
		_lineAlpha = lineAlpha;
		_tops = new Array();
		_bottoms = new Array();
		_topCtls = new Array();
		_bottomCtls = new Array();
		_paths = new Array();
		_x = -_xStep*perm.length/2;
		_y = -iSize+index*_yStep;
		value = perm;
		_index = index;
		//trace("initialise _index to "+_index);
		//trace(_xStep + " " +  _value + " " +iSize + " " + index + " " + _yStep);
		initLabel(label);
	}
	function setOrder(v:Number):Void {
		for(var i = _value.length; i < v; i++) {
			_value[i] = i;
		}
		while(_value.length > v) {
			_value.pop();
		}
		init(_value, _index, _dotId, _xStep, _yStep, _lineWidth, _lineColour, _lineAlpha);
		draw();
	}
	function set initialValue(v:Array):Void {
		_initialValue = v.concat();
	}
	function get initialValue():Array {
		return _initialValue.concat();
	}
	function set value(perm:Array):Void {
		_value = perm.concat();
		_w = _xStep*_value.length;
		draw();
	}
	function get value():Array {
		return _value.concat();
	}
	function set yStep(s:Number):Void {
		_yStep = s;
		draw();
	}
	function draw():Void {
		for (var i = 0; i<_value.length; i++) {
			var a = _tops[i]=this.attachMovie(_dotId, "a"+i, 2*i+_bDepth);
			a._visible = false;
			//trace(_tops);
			//trace("tops["+i+"]="+a);
			a._x = (i+1/2)*_xStep;
			a._y = _xStep/2;
			var b = this.attachMovie(_dotId, "b"+_value[i], 2*i+1+_bDepth);
			b._visible = false;
			_bottoms[i] = b;
			//trace("bottoms["+i+"]="+b);
			b._x = (_value[i]+1/2)*_xStep;
			b._y = _yStep+_xStep/2;
			_topCtls[i] = {_x:a._x, _y:(2*a._y+b._y)/3};
			_bottomCtls[i] = {_x:b._x, _y:(a._y+2*b._y)/3};
		}
		//trace("bottoms = "+_bottoms);
		for (var i = 0; i<_value.length; i++) {
			drawPath(i);
		}
		//trace("draw _bottoms=" + _bottoms);
	}
	var _label:String;
	var _txt:TextField;
	var _fmt:TextFormat;
	//var _txtRollOn:MovieClip;
	var _txtWidth = 100;
	function initLabel(s:String):String {
		//var e = new Expression();
		//e.term = s;
		//var m = attachMovie("Mbox", "m", 0);
		//m.draw(e);
		//m._x = -10;
		//m._y = _yStep/2;	
		//return m.expr.toString();
		return "";
	}
	function showCycleString(changeListener:Function):Void {
		if(_fmt == null) {
			_fmt = new TextFormat();
			_fmt.color = 0xffffff;
			_fmt.font = "_sans";
			_fmt.size = 30;
			_fmt.italic = true;
			_fmt.bold = true;
			_fmt.align = "right";
			createTextField("value_txt", 1, 0, 0, _txtWidth, 40);
			_txt = this["value_txt"];
			_txt.autoSize = "left";
			_txt.wordWrap = false;
			_txt.type = "dynamic";
			_txt.maxChars = 62;
			_txt.html = true;
			_txt.setNewTextFormat(_fmt);
			_txt._x = 0;
			_txt._y = +_yStep/2;
			_txt.onChanged = changeListener;
		}
		_txt.htmlText = Zipper.cycleString(_value);
		_txt.setTextFormat(_fmt);
		_txt._visible = true;
		//trace("showing " + _txt.htmlText);
	}
	function hideCycleString():Void {
		_txt._visible = false;
	}
	function set label(s:String):Void {
		//trace("Set label="+s);
		_label = s;
		_txt = this["label_txt"];
		_txt.htmlText = s;
		_txt.setTextFormat(_fmt);
		//_txtRollOn._x = -_txt.textWidth/2+5;
		//_txtRollOn._width = _txt.textWidth+10;
		//_xStep*_value.length;
	}
	function get label():String {
		return _label;
	}
	function bezier3(t:Number, a:Object, b:Object, c:Object, d:Object):Object {
		//trace("bezier3("+w+")");
		var t2 = t*t;
		var t3 = t*t2;
		var u = 1-t;
		var u2 = u*u;
		var u3 = u*u2;
		var x = t3*b._x+3*t2*u*d._x+3*t*u2*c._x+u3*a._x;
		var y = t3*b._y+3*t2*u*d._y+3*t*u2*c._y+u3*a._y;
		// Calculate rotation of path
		var ut =2*u*t;
		var p = t2-ut;
		var q = u2-ut;
		var xdot = t2*b._x -p*d._x + q*c._x-u2*a._x;
		var ydot = t2*b._y -p*d._y + q*c._y-u2*a._y;
		//var r = (Math.abs(xdot) < 0.01)? 0 : (180*Math.atan(ydot/xdot)/Math.PI);
		var r = (Math.abs(xdot) < 0.01)? 0 : (180*Math.atan2(ydot,xdot)/Math.PI-90);
		return {_x:x, _y:y, _rotation:r};
	}
	static function bezierSplit(t:Number, a:Number, b:Number, c:Number, d:Number):Array {
		var f000 = a;
		var f001 = c;
		var f011 = d;
		var f111 = b;
		var s = 1-t;
		var f00t = s*f000+t*f001;
		var f01t = s*f001+t*f011;
		var f11t = s*f011+t*f111;
		var f0tt = s*f00t+t*f01t;
		var f1tt = s*f01t+t*f11t;
		var fttt = s*f0tt+t*f1tt;
		//trace(f000+" " + f00t + " " + f0tt + " " + fttt);
		var rv = new Array();
		rv[0] = {a:f000, c:f00t, d:f0tt, b:fttt};
		//trace("a="+rv[0].a);
		rv[1] = {a:fttt, c:f1tt, d:f11t, b:f111};
		//trace("d="+rv[1].d);
		return rv;
	}
	function mergeBelow(sorter:Sorter) {
	}
	function nextDepth() {
		return _value.length*3+(++_pathDepth%_value.length);
	}
	function drawPath(p:Number) {
		var a = _tops[p];
		var b = _bottoms[p];
		var c = _topCtls[p];
		var d = _bottomCtls[p];
		var path = this.createEmptyMovieClip("path"+p, 2*_value.length+p+_bDepth);
		_paths[p] = path;
		path.lineStyle(_lineWidth, _lineColour, _lineAlpha);
		path.moveTo(a._x, a._y);
		//trace(a._y+"="+c._y +":::"+d._y+"="+b._y);
		for (var w = 0; w<=lineCount; w++) {
			var t = w/lineCount;
			var bz = bezier3(t, a, b, c, d);
			path.lineTo(bz._x, bz._y);
			//trace(bz._x +","+ bz._y);
		}
		//trace("drawPath _bottoms=" + _bottoms);
	}
	function iconLocationAtFrame(p:Number, t:Number):Object {
		var a = _tops[p];
		var b = _bottoms[p];
		var c = _topCtls[p];
		//{_x:a._x, _y:(2*a._y+b._y)/3};
		var d = _bottomCtls[p];
		//{_x:b._x, _y:(a._y+2*b._y)/3};
		return bezier3(t, a, b, c, d);
	}
	function moveBottom(p:Number, x:Number) {
		_bottoms[p]._x = x+_w/2;
		_bottomCtls[p]._x = x+_w/2;
		//, _y:(a._y+2*b._y)/3};
		drawPath(p);
	}
	function moveTop(p:Number, x:Number) {
		_tops[p]._x = x+_w/2;
		drawPath(p);
	}
	function setKnots(knots:Object) {
		for (var i = 0; i<knots.length; i++) {
			var k = knots[i];
			//trace("setKnots: k=" + k.a._x + "," + k.a._y + " : "+k.b._x + ","+k.b._y+" : "+ k.c._x + "," + k.c._y + " : "+k.d._x + ","+k.d._y+")");
			_tops[i] = k.a;
			_bottoms[i] = k.b;
			_topCtls[i] = k.c;
			_bottomCtls[i] = k.d;
			drawPath(i);
		}
	}
}
