﻿class LibraryPullOut extends PullOut {
	var _dropLength:Number = 0;
	var _dropRate:Number = 22;
	var _x0:Number;
	var _controls:LibraryTree;
	function init() {
		_dropLength = _width-25;
		super.init();
		_controls = this["controls"];
		_controls.init();
	}
	function LibraryPullOut() {
		super();
		_x0 = _x;
	}
	function updateSets():Void {
		trace("updateSets in Library");
		_controls.updateSets();
	}
	function updateFactories():Void {
		trace("updateFactories in Library");
		_controls.updateFactories();
	}
	function slide(dropRate:Number):Void {
		_x += dropRate;
		_level0.factoryPullOut.slide4Library(dropRate);
	}
	function open() {
		trace("open");
		onEnterFrame = function () {
			if (Math.abs(_x-_x0-_dropLength)>0.5) {
				slide(Math.min(_dropRate,-_x+_x0+_dropLength));
			} else {
				super.open();
				onEnterFrame = undefined;
			}
		};
	}
	function close() {
		trace("close");
		onEnterFrame = function () {
			if (Math.abs(_x-_x0)>0.5) {
				slide(-Math.min(_dropRate,_x-_x0));
			} else {
				super.close();
				onEnterFrame = undefined;
			}
		};
	}
}
