﻿class Expression {
	static var IDENTITY:String = "e";
	static var FENCED:Number = 0;
	static var TERM:Number = 1;
	static var LIST:Number = 2;
	var type:Number;
	var fenced:Expression;
	var term:String;
	var power:Number;
	var value:Array;
	static var one:Expression = null;
	static var _id = 1;
	static var _fmt:TextFormat = null;
	function Expression() {
		type = TERM;
		term = IDENTITY;
		power = 1;
	}
	static function set identity(s:String) {
		one = new Expression();
		IDENTITY = s;
		one.term = s;
	}
	static function get identity() {
		return one.clone();
	}
	function typeString():String {
		var s:String;
		switch (type) {
		case FENCED :
			return "FENCED";
		case TERM :
			return "TERM";
		case LIST :
			return "LIST";
		default :
			return "UNKNOWN";
		}
	}
	function clone():Expression {
		var e = new Expression();
		e.type = type;
		e.power = power;
		switch (type) {
		case FENCED :
			e.fenced = fenced.clone();
			break;
		case TERM :
			e.term = term;
			break;
		case LIST :
			e.value = new Array();
			for (var i = 0; i<value.length; i++) {
				e.value[i] = value[i].clone();
			}
			//e.value = value.concat();
			break;
		}
		return e;
	}
	function evaluate():Expression {
		//trace("evaluate("+this+")");
		//var e = new Expression();
		switch (type) {
		case TERM :
			if (power == 0) {
				//trace("R1.0="+identity);
				return identity;
			}
			//trace("R1.1"+clone());
			return clone();
		case FENCED :
			if (power == 1) {
				var f = fenced.evaluate();
				//trace("R2.0="+f);
				return f;
			}
			if (power == 0) {
				//trace("R2.1"+identity);
				return identity;
			}
			var f = clone();
			var invert = (f.power<0);
			f.power = 1;
			f = f.evaluate();
			var g = f;
			for (var i = 1; i<power; i++) {
				g = g.compose(f);
			}
			//trace("f^"+power+"="+g);
			//trace("final return, f = " + g);
			if (invert) {
				g = g.invert();
			}
			//trace("R2.2="+g);
			return g;
		case LIST :
			var f:Expression;
			f = clone();
			for (var i = 0; i<value.length; i++) {
				f.value[i] = value[i].evaluate();
			}
			var g:Expression;
			g = f.value[0];
			for (var i = 1; i<value.length; i++) {
				g = g.compose(f.value[i]);
			}
			//trace("R3="+g);
			return g;
		}
	}
	function equals(e:Expression):Boolean {
		//trace("0");
		var f = evaluate();
		var g = e.evaluate();
		if (f.power != g.power) {
			return false;
		}
		if (f.type != g.type) {
			return false;
		}
		return f.baseEqual(g);
	}
	function baseEqual(e:Expression):Boolean {
		//trace("0");
		if (e.type != type) {
			//trace(e.type + "," + type);
			return false;
		}
		switch (type) {
		case TERM :
			//trace("2");
			return e.term == term;
		case FENCED :
			//trace("3");
			return false;
			//e.fenced.baseEqual(fenced);
		case LIST :
			//trace("4");
			if (e.value.length != value.length) {
				return false;
			}
			for (var i = 0; i<value.length; i++) {
				if (!e.value[i].baseEqual(value[i])) {
					return false;
				}
			}
			return true;
		}
	}
	function toList():Expression {
		var e:Expression = new Expression();
		e.type = LIST;
		e.term = null;
		e.fenced = null;
		e.value = new Array();
		if (type == FENCED || type == TERM) {
			e.value[0] = clone();
		} else {
			e.value = new Array();
			for (var i = 0; i<value.length; i++) {
				e.value[i] = value[i].clone();
			}
			//e.value = value.concat();
		}
		return e;
	}
	function compose(e:Expression):Expression {
		//var r = " "+this+".compose("+e+") this.type="+typeString()+" v="+this+", e.type="+e.typeString()+" v="+e+" ";
		var f = toList();
		//trace(f);
		var g = e.toList();
		//trace(g);
		if (equals(identity)) {
			//trace(r+"returns "+e);
			return e.clone();
		}
		if (e.equals(identity)) {
			//trace(r+"returns "+this);
			return clone();
		}
		var flx = f.value.length-1;
		var fLast = f.value[flx];
		var gFirst = g.value[0];
		if (fLast.baseEqual(gFirst)) {
			//trace("f="+f+" g="+g);
			//trace("fLast="+fLast+" gFirst="+gFirst);
			//trace("baseEquals: fLast.power="+fLast.power+" gFirst.power="+gFirst.power);
			//trace("1 "+f + " " + g);
			fLast.power += gFirst.power;
			// BUT WHAT IF either component is LIST type? Seems OK?
			//trace("2 "+f + " " + g);
			g.value.shift();
			//trace(g);
			if (fLast.power == 0) {
				//trace("fLast.power=0: f.value.length="+f.value.length);
				if (flx == 0) {
					fLast.type = TERM;
					fLast.term = IDENTITY;
					fLast.power = 1;
				} else {
					f.value.pop();
				}
			}
		}
		f.value = f.value.concat(g.value);
		//trace(r+"returns "+f);
		return f;
	}
	function concat(e:Expression):Expression {
		var f = toList();
		var g = e.toList();
		f.value = f.value.concat(g.value);
		return f;
	}
	function fence():Expression {
		var e = new Expression();
		e.fenced = clone();
		e.type = FENCED;
		e.value = null;
		e.power = 1;
		return e;
	}
	function invert() {
		var e = clone();
		if (type == FENCED || type == TERM) {
			e.power = -power;
		} else {
			var temp = value.concat();
			for (var i = 0; i<value.length; ++i) {
				var f = e.value[i]=temp[value.length-i-1];
				//trace("e.value["+i+"]: type="+f.typeString()+" power="+f.power);
				e.value[i] = e.value[i].invert();
			}
		}
		return e;
	}
	function toString():String {
		var v:String;
		switch (type) {
		case TERM :
			v = term;
			break;
		case FENCED :
			v = "("+fenced+")";
			break;
		case LIST :
			v = "";
			for (var i = 0; i<value.length; i++) {
				v += value[i].toString();
			}
			return v;
		}
		if (power != 1) {
			v += "^"+String(power);
		}
		return v;
	}
}
