﻿class Dihedral extends MovieClip {
	var _sides:Number;
	var _order:Number;
	var _poly:MovieClip;
	var _v:Array;
	var _radius:Number;
	var _fillColor:Number;
	var _lineColor:Number;
	var _lineWidth:Number;
	var _alpha:Number;
	var _theta:Number;
	var _turn:Number = 0;
	var _flip:Object = null;
	function Dihedral() {
	}
	public function init(initObj:Object) {
		_sides = initObj.n;
		_order = 2*_sides;
		_v = new Array(_sides);
		_radius = initObj.radius;
		_fillColor = initObj.fillColor;
		_lineColor = initObj.lineColor;
		_lineWidth = initObj.lineWidth;
		_alpha = initObj.alpha;
		_theta = 2*Math.PI/_sides;
	}
	function draw() {
		_poly = createEmptyMovieClip("poly", 1000);
		_poly._transform = {a:1, b:0, c:0, d:1};
		for (var i = 0; i<_sides; i++) {
			var v = _v[i]=_poly.attachMovie("Pad"+(i%6), "pad"+(i%6), i+1);
			v._x = _radius*Math.cos(i*_theta);
			v._y = _radius*Math.sin(i*_theta);
		}
		_poly.beginFill(_fillColor, _alpha);
		_poly.lineStyle(_lineWidth, _lineColor, _alpha);
		_poly.moveTo(_v[_sides-1]._x, _v[_sides-1]._y);
		for (var i = 0; i<_sides; i++) {
			var v = _v[i];
			//trace(v+" "+v._x+","+v._y);
			_poly.lineTo(v._x, v._y);
		}
		_poly.endFill();
	}
	function reDraw(t1:Object):Object {
		_poly.clear();
		var t0 = _poly._transform;
		var na = t1.a*t0.a+t1.b*t0.c;
		var nb = t1.a*t0.b+t1.b*t0.d;
		var nc = t1.c*t0.a+t1.d*t0.c;
		var nd = t1.c*t0.b+t1.d*t0.d;
		t0 = {a:na, b:nb, c:nc, d:nd};
		for (var i = 0; i<_sides; i++) {
			var v = _v[i];
			v._x = _radius*Math.cos(i*_theta);
			v._y = _radius*Math.sin(i*_theta);
			var vx = t0.a*v._x+t0.b*v._y;
			var vy = t0.c*v._x+t0.d*v._y;
			v._x = vx;
			v._y = vy;
		}
		_poly.beginFill(_fillColor, _alpha);
		_poly.lineStyle(_lineWidth, _lineColor, _alpha);
		_poly.moveTo(_v[_sides-1]._x, _v[_sides-1]._y);
		for (var i = 0; i<_sides; i++) {
			var v = _v[i];
			_poly.lineTo(v._x, v._y);
		}
		_poly.endFill();
		return t0;
	}
	function setTransform(t0:Object):Void {
		_poly._transform = t0;
	}
	function rotate(n:Number, t:Number) {
		var phi = -t*n*_theta;
		var tc = Math.cos(phi);
		var ts = Math.sin(phi);
		var transform = {a:tc, b:-ts, c:ts, d:tc};
		var t0 = reDraw(transform);
		//trace("turn="+_turn);
		if (t>1-0.001) {
			setTransform(t0);
		}
	}
	function reflect(n:Number, t:Number) {
		var phi = -2*n*_theta;
		if(_sides%2==0) {
			phi = -n*_theta;
		}
		var tc = Math.cos(phi);
		var ts = Math.sin(phi);
		var u = 1-t;
		var transform = {a:(u+t*tc), b:(t*ts), c:(t*ts), d:(u-t*tc)};
		var t0 = reDraw(transform);
		if (t>1-0.001) {
			setTransform(t0);
		}
	}
}
