﻿class BaseFactoryImpl extends MovieClip implements ShuffleFactory {
	var id:Number = 100;
	var _bar:Bar;
	var _iSize:Number = 20;
	var _zip:Zipper;
	var _value:Array;
	var grow_btn:MovieClip;
	var shrink_btn:MovieClip;
	var _onPress:Function;
	var _onRelease:Function;
	var _zips:Array;
	var _factorySize = 24;
	var _iObj:Object;
	function AbstractFactory() {
	}
	function init(iObj:Object):Void {
		_iObj = iObj;
		trace("initialising AbstractFactory");
		_bar = Bar(attachMovie("Bar", "bar", 1));
		_value = iObj.initial.concat();
		_zips = new Array();
		_bar.init(_value, _iSize, 120, "Pad");
		shrink_btn = attachMovie("Shrink_btn", "shrink_btn", 2);
		//		shrink_btn._x += _bar._width/2;
		grow_btn = attachMovie("Grow_btn", "grow_btn", 3);
		//grow_btn._x = shrink_btn._x+shrink_btn._width;
		grow_btn._x -= _bar._width/2;
		shrink_btn._x = grow_btn._x-grow_btn._width;
		shrink_btn.onRelease = function() {
			if (_parent._value.length>1) {
				_parent._value.pop();
				_parent.reDraw({initial:_parent._value});
			}
		};
		grow_btn.onRelease = function() {
			var i = _parent._value.length;
			if (i<_parent._factorySize) {
				_parent._value[i] = i;
				_parent.reDraw({initial:_parent._value});
			}
		};
		_onPress = _bar.onPress=function () {
			var zip = _parent._zip=Zipper(_parent.attachMovie("Zipper", "zip"+_parent.id++, _parent.id));
			_parent._zips.push(zip);
			zip._x = _x;
			zip.init(_value, _iSize);
			zip._topBar.onPress();
		};
		_onRelease = _bar.onReleaseOutside=_bar.onRelease=function () {
			stopDrag();
			var zip = _parent._zip;
			//trace("zip.y="+zip._y+" y="+_y);
			if(Math.abs(zip._y-_y) < 20) {
				zip._y += 100;
			}
		};
		_xscale = 50;
		_yscale = 50;
		_x = 20+(_value.length*_iSize + shrink_btn._width+grow_btn._width)*_xscale/100;
		_y = -20;
	}
	function mergeCandidate():Void {
		trace("mergeCandidate _zip = " + _zip);
		if (_zip.expanded) {
			for (var z = 0; z<_zips.length; z++) {
				var zip = _zips[z];
				if (_zip == zip || !zip.expanded()) {
					continue;
				}
				trace("testing: " + _zip.play_btn + ":" + zip.rewind_btn); 
				if (_zip._topBar.hitTest(zip._topBar) && _zip.depth == zip.depth) {
					trace("horiz"+_zip+":-:"+zip);
					if (_zip._x<zip._x) {
						if (_zip._x+_zip._width<zip._x+zip._xStep) {
							trace("merge left");
							_zip.mergeLeft(zip);
						}
					} else {
						if (_zip._x>zip._x+zip._width-zip._xStep) {
							trace("merge right");
							zip.mergeLeft(_zip);
						}
					}
				} else if (_zip.order == zip.order) {
					trace(_zip._topBar + " ?hits? "+ zip._bottomBar);
					if (_zip._topBar.hitTest(zip._bottomBar)) {
						trace("merge below");
						zip.mergeAbove(_zip);
					} else if (_zip._bottomBar.hitTest(zip._topBar)) {
						trace("merge above");
						zip.mergeBelow(_zip);
					}
					else {
						trace("no hit");
					}
				}
			}
		} else {
			trace("cannot merge collapsed zippers");
		}
	}
	function reDraw(iObj:Object):Void {
		_bar = Bar(attachMovie("Bar", "bar", 1));
		_value = iObj.initial.concat();
		_bar.init(_value, _iSize, 120, "Pad");
		var newWidth = _bar._width;
		_bar.onPress = _onPress;
		_bar.onRelease = _bar.onReleaseOutside=_onRelease;
		//_bar._x = shrink_btn._x-newWidth/2;
		_bar._x = grow_btn._x+newWidth/2;
	}
	function get iconSize():Number {
		return _iSize;
	}
	function show():Void {
		//trace("show: " + this);
		_visible = true;
	}
	function hide():Void {
		//trace("hide: " + this);
		_visible = false;
	}
}
