﻿import mx.events.EventDispatcher;
class NumberCell extends MovieClip {
	var text:TextField;
	var round:MovieClip;
	var txf:TextFormat;
	var _value:Number;
	var inputs:Array;
	var outputs:Array;
	var _rule:Function;
	var delay:Number=500;
	var lines:Array;
	var timer:Number;
	var _clock:Number;
	var acc:Number=Number.NaN;
	function NumberCell() {}
	function init(v:Number, r:Function, clock:Number) {
		//_value = this["value"] = v;
		_clock = clock;
		createTextField("txField", 20, 0,0,30,40);
		text = this["txField"];
		txf = new TextFormat();
		txf.font="Arial";
		txf.size=20;
		text.autoSize="center";
		text.selectable=true;
		text.border=true;
		text.addListener(this);
		text.text="  ";
		text.setTextFormat(txf);
		text.setNewTextFormat(txf);
		text.type="input";
		text._x -= text._width/2+text.textWidth/2;
		text._y -= text._height/2;
		round = attachMovie("RoundCell", "round", 10);
		round=this["round"];
		round._x -= round._width/2;
		round._y -= round._height/2;
		//trace(this["value"]);
		inputs = new Array();
		outputs = new Array();
		_rule = r;
		lines = new Array();
		for(var i = 0; i < 10; i++) {
			lines[i]=this.createEmptyMovieClip("line"+i, -i);
			lines[i].lineStyle(3,0x660099,100);
		}
		//trace(round.getDepth() + "::"+text.getDepth());
	}
	function addInput(input:NumberCell) {
		if(input != null) {
			text.selectable=false;
			text.border = false;
			text.type="dynamic";
			var inx=inputs.push(input)-1;
			//trace("inx = "+inx); 
			var inCell = inputs[inx];
			input.outputs.push(this);
			//trace(lines[inx]+": ("+inCell._x+ ","+inCell._y+")->("+_x+","+_y+")");
			lines[inx].moveTo(inCell._x-_x,inCell._y-_y);
			lines[inx].lineTo(0,0);
			lines[inx]._alpha=20;
		}
	}
	function set rule(r:Function):Void {
		_rule = r;
	}
	function get rule():Function {
		return _rule;
	}
	function evaluate():Number {
		// apply the rule in turn to each input
		//var acc:Number = 0;
		if(inputs.length == 1) {
			acc = _rule(Number(inputs[0].acc), null);
		}
		else {
			acc = _rule(null, null);
			for(var i = 0; i < inputs.length; i++) {
				trace("inputs["+i+"].acc="+inputs[i].acc+" N()="+Number(inputs[i].acc));
				acc = _rule(acc, Number(inputs[i].acc));
			}
		}
		for(var i = 0; i < outputs.length; i++) {
			outputs[i].evaluate();
		}
		timer = getTimer();
		onEnterFrame = clockedDraw;
		acc=Math.round(acc*100000000)/100000000;
		return acc;
	}
	function highlight(inCell:NumberCell, alpha:Number) {
		for(var i = 0; i < inputs.length; i++) {
			if(inputs[i]==inCell) {
				lines[i]._alpha=alpha;
			}
		}
	}
	function clockedDraw() {
		if((getTimer() - timer)>_clock*delay) {
			onEnterFrame = undefined;
			if(isNaN(acc)) {
				text.text = "";
			}
			else {
				text.text = ""+acc;
			}
			text.setTextFormat(txf);
		}
	}
	function reset() {
		acc = Number.NaN;
		text.text="";
	}
	function resetTexts() {
		timer = getTimer();
		onEnterFrame = clockedDraw;
	}
	function clearText():Void {
		text.text="  ";
	}
	function onChanged(txt:TextField):Void {
		//trace("changed + text=" + txt.text);
		var t = txt.text;
		if(inputs.length==0) {
			_parent.resetTexts();
		}
		while(t.length > 1 && t.substr(t.length-1,1)==" ") 
			t = t.substr(0,t.length-1);
		txt.text = t;
		acc = Number(t);
		for(var i = 0; i < outputs.length; i++) {
			outputs[i].evaluate();
		}
		Selection.setFocus(txt);
		Selection.setSelection(txt.text.length,txt.text.length);
	}
}