package {
	
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.*
	import flash.display.*
    import flash.events.Event;
    import flash.ui.Mouse;
   
    public class Piece extends Sprite {
    	
    	  	
    	//Arc dimensions.
    	private var R:Number = 50;
    	private var r:Number = 40;

    	//Centre of arc. 
    	private var centre_x:Number = (R+r)/(2*Math.sqrt(2));
    	private var centre_y:Number = (R+r)/(2*Math.sqrt(2));
    	
    	//Edges of arc. Whereas centre_x and centre_y are fixed, these co-ordinates change with rotation.
    	//This makes easier for comparison purposes. They are co-ordinates of the midpoint of the straight edges.
    	public var leftEdge_x:Number = -centre_x;
    	public var leftEdge_y:Number = (r+R)/2-centre_y;
    	public var rightEdge_x:Number = (r+R)/2-centre_x ;
    	public var rightEdge_y:Number = -centre_y;
    	
    	//Distance from centre of arc before rotate instead of translate.
    	private var rotateDistance2:Number = 9*(R+r)*(R+r)/100;
    	
    	//Has the piece been clicked on yet?
    	public var active:Boolean = false;
    	
    	//Keep track of the ....
    	public var index:int;
    	
    	private var cursor:Sprite = new Sprite();
		private var over:Boolean = false;
		
		//Constructor.
        public function Piece() {
        	  				
    		//Draw the arc.
    		drawArc();
    		
			//Make alternative cursor.
			//CAUSING ERRORS. GOING TO HIDE THIS
		//	cursor.graphics.lineStyle(2,0x000000,1);
		//	cursor.graphics.drawCircle(0,0,8);
			
			/*
			cursor.graphics.moveTo(4,2);
			cursor.graphics.lineTo(8,-2);
			cursor.graphics.lineTo(12,2);
			*/
       //     addChild(cursor);
         
         	
       //     this.addEventListener(MouseEvent.MOUSE_OVER,newCursor);
       //     this.addEventListener(MouseEvent.MOUSE_MOVE,moveCursor);
       //     this.addEventListener(MouseEvent.MOUSE_OUT,oldCursor);
       //     cursor.visible = false;
            
            
    		//Give it control.
    		this.addEventListener(MouseEvent.MOUSE_DOWN,arcPress);
    		this.addEventListener(MouseEvent.MOUSE_UP,arcRelease);
		
       	}
            
   /*       
        public function newCursor(evt:Event):void {
        	over = true;
        	if ( this.mouseX*this.mouseX+this.mouseY*this.mouseY  > rotateDistance2 ) {
	            cursor.visible = true;
    	        Mouse.hide();
    	    }
        }
       
       public function oldCursor(evt:Event):void {
       		over = false;
            cursor.visible = false;
            Mouse.show();
        }
    */    
        public function moveCursor(evt:MouseEvent):void {
        	if (over) {
        		if ( this.mouseX*this.mouseX+this.mouseY*this.mouseY  > rotateDistance2 ) {
	            	cursor.visible = true;
    	       		Mouse.hide();
    	    	} else {
    	    		cursor.visible = false;
    	       		Mouse.show();
    	    	}	
        	}
            cursor.x = this.mouseX;
            cursor.y = this.mouseY;
            evt.updateAfterEvent();
        }

 
    	
    	//Draw the arc piece.
    	private function drawArc():void{
    		this.graphics.lineStyle(1,0x000000,1,true,"normal","round",null,3);
    		var theta:Number = Math.PI/400;
    		
    		//Stuff for getting a gradient.
 			var fillType:String = GradientType.LINEAR;
 			var colors:Array = [0xffcc00, 0xffff66,0xffcc00];
			var alphas:Array = [1, 1,1];
  			var ratios:Array = [0x00, 0xFF,0x00];
 			var matr:Matrix = new Matrix();
  			matr.createGradientBox(10, 10, 0, 0, 0);
  			var spreadMethod:String = SpreadMethod.PAD;
  			
  			this.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr, spreadMethod);  
    		this.graphics.moveTo(r-centre_x,-centre_y);
    		this.graphics.lineTo(R-centre_x,-centre_y);
    		for (var i:int = 1; i!=201; i++) {
    			this.graphics.lineTo(R*Math.cos(i*theta)-centre_x,R*Math.sin(i*theta)-centre_y);
    		}
    		this.graphics.lineTo(-centre_x,r-centre_y);
    	    for (var j:int = 199; j!=-1; j--) {
    	    	this.graphics.lineTo(r*Math.cos(j*theta)-centre_x,r*Math.sin(j*theta)-centre_y);   
    	    }		
    		this.graphics.endFill();
    		
    	}
    	
    	
    	//Arc has been pressed.
    	private function arcPress(evt:MouseEvent):void {
    		if ( this.mouseX*this.mouseX+this.mouseY*this.mouseY  < rotateDistance2 ) { 	
				evt.target.startDrag();
    	
    	
    		} else {
    			
    			if (this.mouseX <0) {
					this.rotation -= 90;
					var theta:Number = this.rotation*Math.PI/180;
				
					var aa:Number = -0.9*centre_x+this.mouseX;
					trace("x1 = "+aa);
					this.x += Math.cos(theta)*(0.9*centre_x+this.mouseX) - Math.sin(theta)*(0.9*(centre_y-(R+r)/2)+this.mouseY);
					this.y += Math.sin(theta)*(0.9*centre_x+this.mouseX) + Math.cos(theta)*(0.9*(centre_y-(R+r)/2)+this.mouseY);
    			} else {
    				this.rotation += 90;
					var theta1:Number = this.rotation*Math.PI/180;
				
					this.x += Math.cos(theta1)*(0.9*(centre_x-(R+r)/2)+this.mouseX) - Math.sin(theta1)*(0.9*centre_y+this.mouseY);
					this.y += Math.sin(theta1)*(0.9*(centre_x-(R+r)/2)+this.mouseX) + Math.cos(theta1)*(0.9*centre_y+this.mouseY);
    				
    			}
					updateSides();
			}
			//if (!active) {
			//	active = true;
				//this._parent.newArc(200,200);
		//	}
		}
    	
    	//Arc has been released.
    	private function arcRelease(evt:MouseEvent):void {
			this.stopDrag();
			updateSides();
							
		}
		
		private function updateSides():void {
			//Update left and right edges.
			var theta:Number = this.rotation*Math.PI/180;
			leftEdge_x = Math.cos(theta)*(-centre_x) - Math.sin(theta)*((r+R)/2-centre_y);
			leftEdge_y = Math.sin(theta)*(-centre_x) + Math.cos(theta)*((r+R)/2-centre_y);
			rightEdge_x = Math.cos(theta)*((r+R)/2-centre_y) - Math.sin(theta)*(-centre_y);
			rightEdge_y = Math.sin(theta)*((r+R)/2-centre_y) + Math.cos(theta)*(-centre_y);
			/*
			trace("leftEdge_x = "+leftEdge_x);
			trace("leftEdge_y = "+leftEdge_y);
			trace("rightEdge_x = "+rightEdge_x);
			trace("rightEdge_y = "+rightEdge_y);	
			*/
		}
    
    }
}