﻿import Constants;
class Sphere extends MovieClip {
	var __radius:Number = 16;
	//
	// accessors
	//
	function get radius():Number {
		return __radius;
	}
	function set radius(r:Number):Void {
		__radius = r;
	}
	var _xcentre:Number;
	function get xcentre():Number {
		return _xcentre;
	}
	function set xcentre(x:Number):Void {
		_x = x;
		_xcentre=x;
	}
	var _ycentre:Number;
	function get ycentre():Number {
		return _ycentre;
	}
	function set ycentre(y:Number):Void {
		_y = y;
		_ycentre=y;
	}
	var __colour:Number;
	function get colour():Number {
		return __colour;
	}
	function set colour(clr:Number):Void {
		__colour = clr;
	}
	var __alpha:Number;
	function get alpha():Number {
		return __alpha;
	}
	function set alpha(a:Number):Void {
		__alpha = a;
	}
	function drawCircle(x:Number, y:Number, radius:Number):Void {
		var r = radius;
		var n = 8;
		var theta = 45*Constants.kDegreesToRadians;
		var cr = radius/Math.cos(theta/2);
		var angle = 0;
		var cangle = angle-theta/2;
		moveTo(x+r, y);
		for (var i = 0; i<n; i++) {
			angle += theta;
			cangle += theta;
			var endX = r*Math.cos(angle);
			var endY = r*Math.sin(angle);
			var cX = cr*Math.cos(cangle);
			var cY = cr*Math.sin(cangle);
			curveTo(x+cX, y+cY, x+endX, y+endY);
		}
	}
	function drawSphereMixed(clr:Number, a:Number, mix:Number):Void {
		__colour = clr;
		__alpha = a;
		var alphas = [alpha, alpha, alpha];
		var ratios = [0x00, 0x44, 0xFF];
		var colors = [0xffffff, clr, Constants.tintColor(clr, 0, mix)];
		var matrix = {matrixType:"box", x:-radius*1.5, y:-radius*1.5, w:radius*2.5, h:radius*2.5, r:0};
		clear();
		beginGradientFill("radial", colors, alphas, ratios, matrix);
		drawCircle(0, 0, radius);
		endFill();
	}
	function drawSphere(clr:Number, a:Number):Void {
		drawSphereMixed(clr, a, 0.5);
	}

}
