﻿class PrimePot extends BallPot {
	var _snapshot:Boolean = false;									
	var _p:Number;
	var _callback:Function;
	var isPrimePot:Boolean = true;
	var _colour = 0xff0000;
	var _hcolour = 0x337070;
	var _colours:Array = [0xff5555, 0xffff55, 0x55ff55, 0x55ffff, 0x5555ff, 0xff55ff, 0xff0000, 0xffff00, 0x00ff00, 0x00ffff, 0x0000ff, 0xff00ff];
	static var alpha:Number = 50;
	function PrimePot() {
	}
	function init(p:Number, x:Number, y:Number, callback:Function):Number {
		//trace(p+":"+x+":"+y);
		_p = p;

		_callback = callback;
		//var r = Constants.kMaxRadius*Math.sqrt(5*p/3+10);
		var r = BallPot.requiredRadius(Constants.kMaxRadius, p);
		super.init(x, y, r, p, _colours[_p], 100);

		//trace("p="+p+" guys="+guys.length);
		_alpha = alpha;
		var _fmt:TextFormat = new TextFormat();
		_fmt.color = 0x993366;
		_fmt.font = "_sans";
		_fmt.bold = true;
		_fmt.size = 24;
		_fmt.align="center";
		var txt = "pLabel"+p;
		_parent.createTextField(txt, _global.depth++, x-60, y-15, 30, 40);
		_parent[txt].text = p;
		_parent[txt].setTextFormat(_fmt);
		_parent[txt]._visible = false;
		_parent[txt].selectable = false;
		return r;
	}
	function drawBall(mc:MovieClip, rgb:Number):Void {
		mc.drawSphere(0xFF9900, 100);
	}
	static function ndp(n:Number, dp):Number {
		var tp=Math.pow(10,dp);
		return Math.floor(n*tp+0.5)/tp;
	}
	function settled():Boolean {
		if(super.settled()) {
			if(_snapshot) {
				//dump the final ball locations
				//trace("dumping PrimePot("+_p+")");
				var t="static var relpos"+_p+":Array = [";
				var sep = "";
				for(var i = 0; i < guys.length; i++) {
					var b = guys[i];
					t+=sep+"["+ndp(b._x-_x,1)+", "+ndp(b._y-_y,1)+"]";
					sep=", ";
				}
				t +="];";
				trace(t);
			}
			return true;
		}
		return false;
	}
	function onRollOver() {
		_alpha = 100;
		/*
		for (var i = 0; i<guys.length; i++) {
			guys[i]._visible = false;
		}
		*/
		drawSphereMixed(_hcolour, 100, 0.9);
		_parent["pLabel"+_p]._visible = true;
	}
	function onRollOut() {
		_alpha = alpha;
		drawSphereMixed(_colour, 100, 0.3);
		/*
		for (var i = 0; i<guys.length; i++) {
			guys[i]._visible = true;
		}
		*/
		_parent["pLabel"+_p]._visible = false;
	}
	var onReleaseOutside = onRelease;
	function onRelease() {
		_callback(this);
		_parent["pLabel"+_p]._visible = false;
	}
}
