﻿class GridPot extends PittedPot implements HandleReDrawable, SourcePot{
	static var pitId = 0;
	var _pits:Array;
	var _balls:Array;
	var _dropped:Array;
	var _nWide:Number = 10;
	var _nHigh:Number = 10;
	var _separation:Number = 20;
	var _colour:Number = 0x008800;
	var __x:Number;
	var __y:Number;
	var _handle:GridHandle;
	//
	// constructor
	//
	function GridPot() {
	}
	//
	// Initialise BallPot
	//
	function init(x:Number, y:Number, separation:Number, balls:Number, alpha:Number):Void {
		//trace("Pot("+x+","+y+")");
		_nHigh = Math.floor(Math.sqrt(balls)+0.5);
		_nWide = Math.floor((balls+_nHigh-1)/_nHigh);
		//_nWide = nWide;
		//_nHigh = nHigh;
		__x = x;
		__y = y;
		_separation = separation;
		_pits = new Array();
		_balls = new Array();
		_dropped = new Array();
		var maxi:Number = 0;
		var maxj:Number = 0;
		for (var i = 0; i<_nHigh && balls>0; i++) {
			maxi = Math.max(i, maxi);
			//var p = _pits[i]=new Array();
			for (var j = 0; j<_nWide && balls-->0; j++) {
				maxj = Math.max(j, maxj);
				var pit = _level0.attachMovie("Group", "pit"+(++pitId), _global.depth++);
				//var pit = p[j];
				pit.init(x+j*separation/2, y+i*separation/2, separation/4, 0, _colour, 100);
				_balls.push(pit.guys[0]);
				_pits.push(pit);
			}
		}
		_alpha = alpha;
		_width = (maxj+1)*separation/2;
		_height = (maxi+1)*separation/2;
		_nHigh = maxi;
		_nWide = maxj;
		_x = x+(_width-separation)/4;
		_y = y+(_height-separation)/4;
		_handle = _level0.attachMovie("GridHandle", "handle", _global.depth++);
		_handle.init(String(_pits.length), this, x, y, _width-separation/4, _height-separation/4);
	}
	function drop():Ball {
		var b = _balls.pop();
		b.pot = null;
		_dropped.push(b);
		return b;
	}
	function get dropped():Array {
		return _dropped;
	}
	function handleReDraw(handle):Void {
		var w = handle.width;
		var h = handle.height;
		var ourH = h+_separation/4;
		var nHigh = 2*ourH/_separation;
		redraw(nHigh);
		var newW = _width-_separation/4;
		var newH = _height-_separation/4;
			handle.width = newW;
			handle.height = newH;
	}
	function handleSnap(handle):Void {
		var w = handle.width;
		var h = handle.height;
		var ourH = h+_separation/4;
		var nHigh = 2*ourH/_separation;
		redraw(nHigh);
		var newW = _width-_separation/4;
		var newH = _height-_separation/4;
			handle.width = newW;
			handle.height = newH;
	}
	function redraw(nHigh) {
		//trace("redraw("+nHigh+")");
		if (nHigh<1) {
			nHigh=1;
		}
		var total = _pits.length;
		_nHigh = nHigh;
		_nWide = Math.floor((total+_nHigh-1)/_nHigh);
		for (var i = 0; i<_nHigh; i++) {
			for (var j = 0; j<_nWide; j++) {
				var k = i*_nWide+j;
				if (k<_pits.length) {
					_pits[k].xcentre = __x+j*_separation/2;
					_pits[k].ycentre = __y+i*_separation/2;
				}
				//trace(k+","+ _pits[k].xcentre+","+ _pits[k].ycentre);
				if (k<_balls.length) {
					_balls[k]._visible = false;
					_balls[k].xcentre = __x+j*_separation/2;
					_balls[k].ycentre = __y+i*_separation/2;
				}
			}
		}
		_width = _nWide*_separation/2;
		_height = _nHigh*_separation/2;
		_x = __x+(_width-_separation)/4;
		_y = __y+(_height-_separation)/4;
	}
	function shrink() {
		redraw(_nHigh-1);
	}
	function grow() {
		redraw(_nHigh+1);
	}
	function deleteChildren() {
		var p:BallPot;
		while(p = BallPot(_pits.pop())) {
			p.removeAndDestroy();
		}
		_handle.removeMovieClip();
	}
}
