<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:xdt="http://www.w3.org/2005/02/xpath-datatypes">
    <xsl:output version="1.0" encoding="UTF-8" indent="no" omit-xml-declaration="no" media-type="text/html" />
    <xsl:template match="/">
        <html>
            <head>
                <title />
            </head>
            <body>
                <xsl:for-each select="cuisenaire">
                    <br />
                    <h1 style="background-color:#FFFF80; ">
                        <span style="background-color:#FFFF80; font-family:Tahoma; ">Configuration Editor</span>
                        <br />
                        <span style="background-color:#FFFF80; font-family:Tahoma; ">for the Cuisenaire Activity</span>
                    </h1>
                    <br />
                    <table border="1">
                        <tbody>
                            <tr>
                                <td>
                                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">Stage Width</span>
                                </td>
                                <td>
                                    <xsl:for-each select="@stageW">
                                        <input style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; " value="">
                                            <xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
                                        </input>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">Stage Height</span>
                                </td>
                                <td>
                                    <xsl:for-each select="@stageH">
                                        <input style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; " value="">
                                            <xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
                                        </input>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">Initial Unit Size (pixels)</span>
                                </td>
                                <td>
                                    <xsl:for-each select="@scaler">
                                        <input style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; " value="">
                                            <xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
                                        </input>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">Minimum scale</span>
                                </td>
                                <td>
                                    <xsl:for-each select="@minScale">
                                        <select style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; " size="0">
                                            <option value="-3">
                                                <xsl:if test=".='-3'">
                                                    <xsl:attribute name="selected">1</xsl:attribute>
                                                </xsl:if>-3</option>
                                            <option value="-2">
                                                <xsl:if test=".='-2'">
                                                    <xsl:attribute name="selected">1</xsl:attribute>
                                                </xsl:if>-2</option>
                                            <option value="-1">
                                                <xsl:if test=".='-1'">
                                                    <xsl:attribute name="selected">1</xsl:attribute>
                                                </xsl:if>-1</option>
                                            <option value="0">
                                                <xsl:if test=".='0'">
                                                    <xsl:attribute name="selected">1</xsl:attribute>
                                                </xsl:if>0</option>
                                        </select>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">Maximum scale</span>
                                </td>
                                <td>
                                    <xsl:for-each select="@maxScale">
                                        <select style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; " size="0">
                                            <option value="0">
                                                <xsl:if test=".='0'">
                                                    <xsl:attribute name="selected">1</xsl:attribute>
                                                </xsl:if>0</option>
                                            <option value="1">
                                                <xsl:if test=".='1'">
                                                    <xsl:attribute name="selected">1</xsl:attribute>
                                                </xsl:if>1</option>
                                            <option value="2">
                                                <xsl:if test=".='2'">
                                                    <xsl:attribute name="selected">1</xsl:attribute>
                                                </xsl:if>2</option>
                                            <option value="3">
                                                <xsl:if test=".='3'">
                                                    <xsl:attribute name="selected">1</xsl:attribute>
                                                </xsl:if>3</option>
                                        </select>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">Grid Width (squares)</span>
                                </td>
                                <td>
                                    <xsl:for-each select="@gridWidth">
                                        <input style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; " value="">
                                            <xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
                                        </input>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">Grid Height (squares)</span>
                                </td>
                                <td>
                                    <xsl:for-each select="@gridHeight">
                                        <input style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; " value="">
                                            <xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
                                        </input>
                                    </xsl:for-each>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">Grid Visible</span>
                                </td>
                                <td>
                                    <xsl:for-each select="@gridVisible">
                                        <input style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; " type="checkbox">
                                            <xsl:choose>
                                                <xsl:when test=".='true'">
                                                    <xsl:attribute name="checked">1</xsl:attribute>
                                                </xsl:when>
                                                <xsl:when test=".='1'">
                                                    <xsl:attribute name="checked">1</xsl:attribute>
                                                </xsl:when>
                                            </xsl:choose>
                                        </input>
                                    </xsl:for-each>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">&#160;</span>
                    <xsl:for-each select="rods">
                        <table border="1">
                            <thead>
                                <tr>
                                    <td>
                                        <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">Rods that may be created</span>
                                    </td>
                                </tr>
                            </thead>
                            <tbody>
                                <xsl:for-each select="rod">
                                    <tr>
                                        <td>
                                            <xsl:for-each select="@colour">
                                                <select style="background-color:#FFFF80; " size="0">
                                                    <option value="White">
                                                        <xsl:if test=".='White'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>White</option>
                                                    <option value="Red">
                                                        <xsl:if test=".='Red'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>Red</option>
                                                    <option value="Green">
                                                        <xsl:if test=".='Green'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>Green</option>
                                                    <option value="Pink">
                                                        <xsl:if test=".='Pink'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>Pink</option>
                                                    <option value="Yellow">
                                                        <xsl:if test=".='Yellow'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>Yellow</option>
                                                    <option value="Dark Green">
                                                        <xsl:if test=".='Dark Green'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>Dark Green</option>
                                                    <option value="Black">
                                                        <xsl:if test=".='Black'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>Black</option>
                                                    <option value="Brown">
                                                        <xsl:if test=".='Brown'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>Brown</option>
                                                    <option value="Blue">
                                                        <xsl:if test=".='Blue'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>Blue</option>
                                                    <option value="Orange">
                                                        <xsl:if test=".='Orange'">
                                                            <xsl:attribute name="selected">1</xsl:attribute>
                                                        </xsl:if>Orange</option>
                                                </select>
                                            </xsl:for-each>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </tbody>
                        </table>
                    </xsl:for-each>
                    <br />
                    <xsl:for-each select="gridMasks">
                        <br />
                        <table border="1">
                            <thead>
                                <tr>
                                    <td>
                                        <span style="background-color:#FFFF80; color:#800000; ">Mask if ax+bx+c &gt; 0 : </span>
                                    </td>
                                    <td />
                                    <td />
                                </tr>
                                <tr>
                                    <td>
                                        <span style="background-color:#FFFF80; color:#800000; ">a</span>
                                    </td>
                                    <td>
                                        <span style="background-color:#FFFF80; color:#800000; ">b</span>
                                    </td>
                                    <td>
                                        <span style="background-color:#FFFF80; color:#800000; ">c</span>
                                    </td>
                                </tr>
                            </thead>
                            <tbody>
                                <xsl:for-each select="mask">
                                    <tr>
                                        <td>
                                            <xsl:for-each select="@a">
                                                <input style="background-color:#FFFF80; color:#800000; " value="">
                                                    <xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
                                                </input>
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:for-each select="@b">
                                                <input style="background-color:#FFFF80; color:#800000; " value="">
                                                    <xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
                                                </input>
                                            </xsl:for-each>
                                        </td>
                                        <td>
                                            <xsl:for-each select="@c">
                                                <input style="background-color:#FFFF80; color:#800000; " value="">
                                                    <xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
                                                </input>
                                            </xsl:for-each>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </tbody>
                        </table>
                    </xsl:for-each>
                    <br />
                    <span style="background-color:#FFFF80; color:#000040; font-family:@Arial Unicode MS; ">&#160;</span>
                </xsl:for-each>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
