﻿class RodPlaced extends Rod {
	var dragging:Boolean = false;
	var keyListener:Object;
	static var top:MovieClip;
	var occupies:Object;
	var sidewaysOnly:Boolean = false;
	var deletable:Boolean = true;
	function RodPlaced() {
	}
	function init(len:Number) {
		super.init(len);
		keyListener = createEmptyMovieClip("keyListener", 100);
		keyListener.rod = this;
		if(config.allowRotation) {
			keyListener.onKeyDown = function() {
				if(this.rod.length != 1) {
					this.rod._rotation = 90-this.rod._rotation;
				}
			}
		}
		//addBumper();
		top = this;
		occupies={};
		if(coloured || fixed) {
			var snapx:Number = config.snap(_x);
			var snapy:Number = config.snap(_y);
			claimed(snapx, snapy, length, _rotation);
		}
		if(!fixed) {
			onRollOver = rollOver;
			onRollOut = rollOut;
			onReleaseOutside = releaseOutside;
			onRelease = release;
			onPress = press;
			//onReleaseOutside = releaseOutside;
		}
	}
	function rollOver() {
		highlight = true;
	}
	function rollOut() {
		highlight = false;
		//press();
	}
	function releaseOutside() {
		release();
	}
	function release() {
		//trace("RELEASE");
		var trash = _level0.trash;
		if(deletable && trash.hitTest(_level0._xmouse,_level0._ymouse, false)) {
			//trace("Hit Trash");
			trash.onPress();
			return;
		}
		var snapx:Number = config.snap(_x);
		var snapy:Number = config.snap(_y);
		if(claimed(snapx, snapy, length, _rotation)) {
			this.stopDrag();
			_x = snapx*config.scaler;
			_y = snapy*config.scaler;
			Key.removeListener(keyListener);
			dragging = false;
			_level0.statusBar._visible = false;
			trace(this.toString());
		}
		//press();
	}
	function press() {
		if(_level0.grid.panning) {
			return;
		}
		//if(!dragging) {
			for(var i = 0; i < rods.length; i++) {
				var rod:RodPlaced = RodPlaced(rods[i]);
				if(rod.dragging) {
					rod.onRelease();
					return;
				}
			}
			//_x += 1;
			//_y += 1;
			Key.addListener(keyListener);
			//top = this;
			if(!sidewaysOnly) {
				this.startDrag(true);
			}
			else {
				var midx = _level0.grid._width/2;
				this.startDrag(true, midx-245, _y, midx+260, _y);
			}
			dragging = true;
			occupies = null;
			if(length != 1) {
				_level0.statusBar._visible = true;
			}
		/*
		}
		else {
			var snapx:Number = config.snap(_x);
			var snapy:Number = config.snap(_y);
			if(claimed(snapx, snapy, length, _rotation)) {
				this.stopDrag();
				_x = snapx*config.scaler;
				_y = snapy*config.scaler;
				Key.removeListener(keyListener);
				dragging = false;
				_level0.statusBar._visible = false;
				//trace(this.toString());
			}
		}
		*/
	}
	function claimed(snapx:Number, snapy:Number, length:Number, rotation:Number): Boolean {
		var claims:Object = claimHash(snapx, snapy, length, rotation);
		for(var claim in claims) {
			//trace("claim="+claim + " rods=" + rods + " rods.length="+rods.length);
			for(var j = 0; j < rods.length; j++) {
				var rod:RodPlaced = RodPlaced(rods[j]);
				//trace("rod.occupies="+rod.occupies);
				for(var c in rod.occupies) {
					//trace("testing "+c);
				}
				if(rod.occupies[claim]) {
					//trace("occupied");
					return false;
				}
			}
		}
		occupies = claims;
		//trace("vacant claims="+claims+" occupies="+occupies);
		return true;
	}
	static function claimHash(snapx:Number, snapy:Number, length:Number, rotation:Number):Object {
		//trace("claim");
		var claim:Object = {};
		var offset = Math.floor((length+1)/2);
		for(var i = 0; i < length; i++) {
			if(rotation == 0) {
				//trace(""+(snapx+i-offset)+":"+snapy);
				claim[""+(snapx+i-offset)+":"+snapy]=true;
			}
			else {
				//trace(""+(snapx-1)+":"+(snapy+i-offset));
				claim[""+(snapx-1)+":"+(snapy+i-offset)]=true;
			}
		}
		return claim;
	}
	function overLapping():Boolean {
		for(var i = 0; i < rods.length; i++) {
			var rod:Rod = Rod(rods[i]);
			//trace(this +".hitTest("+rod+")=="+this.hitTest(rod));
			if(getDepth() != rod.getDepth()) {
				if(this.hitTest(rod)) {
					//trace("overlapping");
					return true;
				}
			}
		}
		return false;
	}
/*
	function addBumper() {
		bumper = attachMovie("Square", "bumper", 1);
		bumper._width = Math.round(_width - config.scaler/2);
		bumper._height = Math.round(_height - config.scaler/2);
		bumper._x = ox+Math.round(config.scaler/4);
		bumper._y = oy+Math.round(config.scaler/4);
		bumper.id = getDepth();
		bumpers.push(bumper);
	}
	
	function overLapping():Boolean {
		for(var i = 0; i < rods.length; i++) {
			var rod:Rod = Rod(rods[i]);
			//trace(this +".hitTest("+rod+")=="+this.hitTest(rod));
			if(getDepth() != rod.getDepth()) {
				if(this.hitTest(rod)) {
					//trace("overlapping");
					return true;
				}
			}
		}
		return false;
	}
	*/
	/*
	function overLapping():Boolean {
		trace("bumpers ="+ bumpers.length);
		for(var i = 0; i < bumpers.length; i++) {
			trace("overlap["+i+"] identical="+(getDepth()==bumpers[i].id));
			//trace("hitTest="+bumper.hitTest(bumpers[i]));
			//trace(bumper);
			if(bumpers[i].id != getDepth() && bumper.hitTest(bumpers[i])) {
				return true;
			}
		}
		return false;
	}
	*/
}