﻿import LayeredPath;
import Config;
class Rod extends MovieClip {
	private var _length:Number;
	var colour:Number;
	var config:Config;
	var ox:Number=0;
	var oy:Number=0;
	var colourNames:Array;
	var ncolours:Array;
	var hcolours:Array;
	var colours:Array;
	var rods:Array;
	var _scaler:Number;
	var fixed:Boolean = false;
	var coloured:Boolean = true;
	function Rod() {
	}
	function set length(len:Number):Void {
		_length = len;
	}
	function get length():Number {
		return _length;
	}
	function init(len:Number, scaler:Number):Void {
		if(scaler == null) {
			_scaler = config.scaler;
		}
		length = len;
		colourNames = config.colourNames;
		ncolours = config.ncolours;
		hcolours = config.hcolours;
		colours = ncolours;
		draw();
	}
	function draw():Void {
		var lace:LayeredPath = new LayeredPath(this);
		var w = length * _scaler;
		var h = _scaler;
		var fillColor = coloured ? colours[length]: 0x888888;
		var color = coloured ? 0x000000 : fillColor;
		lace.addLayer(new PolyStyle({color:color, thickness:1, alpha:100, fillType:"solid", fillColor:fillColor, fillAlpha:100}));
		lace.addMoveTo(ox, oy);
		lace.addLineTo(ox+w, oy);
		lace.addLineTo(ox+w, oy+h);
		lace.addLineTo(ox, oy+h);		
		lace.addLineTo(ox,oy);
		lace.draw();
	}
	function set highlight(b:Boolean):Void {
		colours = b ? hcolours : ncolours;
		draw();
	}
	function get highlight():Boolean {
		return colours == hcolours;
	}
	function toString():String {
		//
		// This serialise a Rod to config.xml initialRod format
		//
		var s = "<initialRod length=\""+length+"\" rotation=\""+_rotation+"\" x=\""+_x+"\" y=\""+_y+"\" coloured=\"false\" fixed=\"true\" />";
		return s;
	}
}