﻿import Rod;
import Grid;
import LayeredPath;
import Config;
class Panel extends MovieClip {
	var rods:Array;
	var depth:Number = 0;
	var _grid:Grid;
	var gridMoveX:Number = 0;
	var gridMoveY:Number = 0;
	var scale:Number = 1;
	var config:Config;
	var magPlus:Button;
	var magMinus:Button;
	var panMode:Boolean = false;
	var panPointer:MovieClip = null;
	var newRodMenu:mx.controls.Menu;
	var viewMenu:mx.controls.Menu;
	function Panel() {
		rods = new Array();
	}
	function init(grid:Grid) {
		_grid = grid;
		addMenuBar();
		//draw();
	}
	function removeMenus() {
		//trace("REMOVE MENUS");
		if(newRodMenu != null) {
			newRodMenu.removeAll();
		}
		_level0.menuBar.setMenuEnabledAt(0,false);
	}
	/*
	function removeMenus() {
		//trace("REMOVE MENUS");
		if(newRodMenu != null) {
			newRodMenu.removeAll();
		}
		if(viewMenu != null) {
			viewMenu.removeAll();
		}
		_level0.menuBar.removeMenuAt(1);
		_level0.menuBar.removeMenuAt(0);
	}
	*/
	function addMenuBar() {
		// New Rod menu
			newRodMenu = _level0.menuBar.getMenuAt(0);
			if(newRodMenu == null) {
				newRodMenu = _level0.menuBar.addMenu("Rods");
				_level0.menuBar.setMenuEnabledAt(0,false);
			}
		if(!config.allRodsHidden()) {
			_level0.menuBar.setMenuEnabledAt(0,true);
			if(!config.hideButtons[1]) {
				newRodMenu.addMenuItem({label:"  Whites                               ", instanceName:"whiteRod", icon:"WhiteRod", data:1});
			}
			if(!config.hideButtons[2]) {
				newRodMenu.addMenuItem({label:"     Reds                              ", instanceName:"redRod", icon:"RedRod", data:2});
			}
			if(!config.hideButtons[3]) {
				newRodMenu.addMenuItem({label:"        Greens                         ", instanceName:"greenRod", icon:"GreenRod", data:3});
			}
			if(!config.hideButtons[4]) {
				newRodMenu.addMenuItem({label:"           Pinks                       ", instanceName:"pinkRod", icon:"PinkRod", data:4});
			}
			if(!config.hideButtons[5]) {
				newRodMenu.addMenuItem({label:"              Yellows                  ", instanceName:"yellowRod", icon:"YellowRod", data:5});
			}
			if(!config.hideButtons[6]) {
				newRodMenu.addMenuItem({label:"                 Dark Greens           ", instanceName:"dkGreenRod", icon:"DkGreenRod", data:6});
			}
			if(!config.hideButtons[7]) {
				newRodMenu.addMenuItem({label:"                    Blacks             ", instanceName:"blackRod", icon:"BlackRod", data:7});
			}
			if(!config.hideButtons[8]) {
				newRodMenu.addMenuItem({label:"                       Browns          ", instanceName:"brownRod", icon:"BrownRod", data:8});
			}
			if(!config.hideButtons[9]) {
				newRodMenu.addMenuItem({label:"                          Blues        ", instanceName:"blueRod", icon:"BlueRod", data:9});
			}
			if(!config.hideButtons[10]) {
				newRodMenu.addMenuItem({label:"                             Oranges   ", instanceName:"orangeRod", icon:"OrangeRod", data:10});
			}
			newRodMenu.addEventListener("change", this);
			newRodMenu.addEventListener("rollOver", this);
		}
		// View menu
		viewMenu = _level0.menuBar.getMenuAt(1);
		if(viewMenu == null) {
			viewMenu = _level0.menuBar.addMenu("View");
		}
		viewMenu.addMenuItem({label:"Larger", instanceName:"zoomIn", icon:"ZoomIn", data:"zoomIn"});
		viewMenu.addMenuItem({label:"Smaller", instanceName:"zoomOut", icon:"ZoomOut", data:"zoomOut"});
		viewMenu.addMenuItem({label:"Move", instanceName:"pan", icon:"PanIcon", data:"pan"});
		/*
		viewMenu.addMenuItem({label:"Move", instanceName:"arrow", icon:"Arrow", data:"arrow"});
		*/
		viewMenu.addEventListener("change", this);
		viewMenu.addEventListener("rollOver", this);
		var printMenu = viewMenu.addMenuItem({label:"Print", data:"print"});
	}
	function rollOver(evt) {
		doArrow();
	}
	function change(evt) {
		doArrow();
		var data = evt.menuItem.attributes.data;
		switch(evt.menuItem.attributes.data) {
			case "zoomIn":
				scaleUp();
				break;
			case "zoomOut":
				scaleDown();
				break;
			case "print":
				//trace("print");
				print(_level0, "bmovie");
				break;
			case "pan" :
				//trace("pan");
				panMode = true;
				Mouse.hide();
				Mouse.addListener(this);
				panPointer = _level0.panPointer;
				panPointer._visible = true;
				_grid.panMode();
				break;
			case "arrow":
				//trace("arrow");
				doArrow();
				break;
			default: {
				var length:Number = Number(data);
				_grid.addRod(length);
				break;
			}
		}
	}
	function doArrow():Void {
		panMode = false;
		Mouse.show();
		Mouse.removeListener(this);
		panPointer._visible = false;
		_grid.panModeOff();
	}
	function onMouseMove() {
		if(panMode) {
			panPointer._x = _level0._xmouse;
			panPointer._y = _level0._ymouse;
		}
	}
	function addRodButton(len:Number):Rod {
		var rod:RodButton = RodButton(attachMovie("RodButton", config.colourNames[len]+":btn:"+depth, depth++, {config:config}));
		rods[len] = rod;
		rod.init(_grid, len);
		return rod;
	}
	function doScale() {
		_grid._xscale = _grid._yscale = 100*Math.pow(2,(scale-1)/2);
		_grid._x = config.stageW/2 - _grid._width/2;
		_grid._y = config.stageH/2 - _grid._height/2;
	}
	function scaleDown() {
		if(--scale < config.minScale) {
			scale = config.minScale;
		}
		doScale();
	}
	function scaleUp() {
		if(++scale > config.maxScale) {
			scale = config.maxScale;
		}
		doScale();
	}
}