﻿import PolyStyle;
//import ps.logging.Logger;
//
// LayeredPath is helpful when you need to draw things with 3D effects.
// You define layer styles, offsets (for directional lighting effects) and paths
// before calling one of the draw routines. Either draw the whole layer stack with
// draw() or just one layer with drawLayer(). You might want to do the latter if you
// are drawing a complex object consisting of many LayeredPaths.
//
class LayeredPath {
	var color:Number;
	var layerStyles:Array;
	var layerOffsets:Array;
	var paths:Array;
	var _mc:MovieClip;
	function LayeredPath(mc:MovieClip) {
		layerStyles = new Array();
		layerOffsets = new Array();
		paths = new Array();
		_mc = mc;
	}
	function init(iObj:Object) {
		layerStyles = iObj.layerStyles;
		layerOffsets = iObj.layerOffsets;
		paths = iObj.paths;
		_mc = iObj._mc;
	}
	public function addMoveTo(x:Number, y:Number):Void {
		paths.push({type:"moveTo", x:x, y:y});
	}
	public function addLineTo(x:Number, y:Number):Void {
		//trace("addLineTo "+x+","+y);
		paths.push({type:"lineTo", x:x, y:y});
	}
	public function addCurveTo(ctlx:Number, ctly:Number, x:Number, y:Number):Void {
		paths.push({type:"curveTo", ctlx:ctlx, ctly:ctly, x:x, y:y});
	}
	public function addLayer(style:PolyStyle, offset:Object):Void {
		if(offset == null) {
			offset={x:0,y:0};
		}
		layerStyles.push(style);
		layerOffsets.push(offset);
	}
	/*
			// Line-segment only copy
			public function addArc(radius:Number, angle:Number, dx:Number, dy:Number):Void {
				// dx, dy indicate direction we are pointing initially.
				// If not supplied, we assume linear
				angle = -angle;
				var p1 = paths[paths.length-1];
				if (paths.length>1 && (dx == null || dx == null)) {
					var p0 = paths[paths.length-2];
					dx = (p1.ax == null) ? (p1.x-p0.x) : (p1.ax-p0.x);
					dy = (p1.ay == null) ? (p1.y-p0.y) : (p1.ay-p0.y);
				}
				var atan2 = Math.atan2(dy, dx);
				var theta = atan2;
				if (theta<0) {
					theta += 2*Math.PI;
				}
				theta -= Math.PI/2;
				var ds = Math.sqrt(dx*dx+dy*dy);
				var sa = angle/Math.abs(angle);
				var cx = p1.x-radius*dy*sa/ds;
				var cy = p1.y+radius*dx*sa/ds;
				var arcLength = Math.abs(radius*angle);
				var steps = Math.floor((arcLength+10)/10);
				var da = angle/steps;
				for (var step = 0; step<=steps; step++) {
					var a = theta+da*step;
					addLineTo(cx+radius*Math.cos(a), cy+radius*Math.sin(a));
				}
			}
			*/
	public function addArc(radius:Number, angle:Number, dx:Number, dy:Number):Object {
		// dx, dy indicate direction we are pointing initially
		// They are optional parameters as we can usually calculate them
		angle = -angle;
		var p1 = paths[paths.length-1];
		if (paths.length>1 && (dx == null || dx == null)) {
			var p0 = paths[paths.length-2];
			dx = (p1.ctlx == null) ? (p1.x-p0.x) : (p1.ctlx-p0.ctlx);
			dy = (p1.ctly == null) ? (p1.y-p0.y) : (p1.ctly-p0.ctly);
		}
		var atan2 = Math.atan2(dy, dx);
		var theta = atan2;
		if (theta<0) {
			theta += 2*Math.PI;
		}
		theta -= Math.PI/2;
		var ds = Math.sqrt(dx*dx+dy*dy);
		var sa = angle/Math.abs(angle);
		var cx = p1.x-radius*dy*sa/ds;
		var cy = p1.y+radius*dx*sa/ds;
		//trace(cx+","+cy);
		var arcLength = Math.abs(radius*angle);
		var steps = Math.floor((arcLength+20)/20);
		var da = angle/steps;
		for (var step = 1; step<=steps; step++) {
			var a = theta+da*step;
			var x1 = cx+radius*Math.cos(a-da/2);
			var y1 = cy+radius*Math.sin(a-da/2);
			var x = cx+radius*Math.cos(a);
			var y = cy+radius*Math.sin(a);
			var ax = cx+(x1-cx)/Math.cos(da/2);
			var ay = cy+(y1-cy)/Math.cos(da/2);
			addCurveTo(ax, ay, x, y);
		}
		return({x:x, y:y});
	}
	public function newFill():Void {
		paths.push({type:"newfill"});
	}
	public function drawLayer(index:Number):Void {
		var style = layerStyles[index];
		var offset = layerOffsets[index];
		style.beginPoly(_mc);
		for (var p = 0; p<paths.length; p++) {
			var path = paths[p];
			var x = Math.round(path.x+offset.x);
			var y = Math.round(path.y+offset.y);
			//Logger.log(Logger.DEBUG, path.type+"("+path.x+","+path.y+(path.ctlx == null ? "" : ","+path.ctlx+","+path.ctly)+")");
			switch (path.type) {
			case "moveTo" :
				_mc.moveTo(x, y);
				break;
			case "lineTo" :
				//trace("lineTo: "+x+","+y);
				_mc.lineTo(x, y);
				break;
			case "curveTo" :
				var ax = path.ctlx+offset.x;
				var ay = path.ctly+offset.y;
				_mc.curveTo(ax, ay, x, y);
				break;
			case "endfill" :
				style.endPoly(_mc);
				style.fillType="none";
				style.beginPoly(_mc);
				break;
			}
			
		}
		style.endPoly(_mc);
	}
	public function draw():Void {
		for (var i = 0; i<layerStyles.length; i++) {
			drawLayer(i);
		}
	}
}
