﻿import Config;
import Rod;
import LayeredPath;
class Grid extends MovieClip {
	var ox:Number;
	var oy:Number;
	var _w:Number;
	var _h:Number;
	var depth:Number = 10;
	var rods:Array;
	var config:Config;
	var panning:Boolean = false;
	var dragx:Number;
	var dragy:Number;
	var mouseDown:Boolean = false;
	function Grid() {
		rods = new Array();
		//Mouse.removeListener(this);
	}
	function init(w:Number, h:Number, mask:MovieClip) {
		_w = Math.abs(Math.round(w/2)*2);
		_h = Math.abs(Math.round(h/2)*2);
		draw(_w,_h);
		_x = -_w/2;
		_y = -_h/2;
		ox = Math.abs(_x);
		oy = Math.abs(_y);
		//trace("ox:oy="+ox + ","+oy);
		drawGrid();
		if(mask != null) {
			this.setMask(mask);
		}
	}
	function draw(w:Number, h:Number):Void {
		//trace("Grid");
		var lace:LayeredPath = new LayeredPath(this);
		lace.addLayer(new PolyStyle({color:0xffffff, thickness:0, alpha:100, fillType:"solid", fillColor:config.gridBackground, fillAlpha:100}));
		lace.addMoveTo(0, 0);
		lace.addLineTo(w, 0);
		lace.addLineTo(w, h);
		lace.addLineTo(0, h);		
		lace.addLineTo(0,0);
		lace.draw();
	}
	function drawGrid() {
		lineStyle(1, config.gridForeground, 100);
		for(var x = 0, i=0; x < _w/2; x+=config.scaler, i++) {
			//trace(ox + ","+x+","+_h);
			if(i%10==0) {
				lineStyle(2, config.gridForeground, 100);
			}
			else if(i%5 == 0) {
				lineStyle(1, config.gridForeground, 100);
			}
			else {
				lineStyle(1, config.gridForeground, 60);
			}
			moveTo(ox+x, 0);
			lineTo(ox+x, _h);
			if(x > 0) {
				moveTo(ox-x, 0);
				lineTo(ox-x, _h);
			}
		}
		//trace("Y");
		for(var y = 0, i = 0; y < _h/2; y+=config.scaler, i++) {
			//trace(oy + ","+y+","+_w);
			if(i%10==0) {
				lineStyle(2, config.gridForeground, 100);
			}
			else if(i%5 == 0) {
				lineStyle(1, config.gridForeground, 100);
			}
			else {
				lineStyle(1, config.gridForeground, 60);
			}
			moveTo(0, oy+y);
			lineTo(_w, oy+y);
			if(y > 0) {
				moveTo(0, oy-y);
				lineTo(_w, oy-y);
			}
		}
	}
	function addInitialRods() {
		//
		for(var i = 0; i < config.initialRods.length; i++) {
			var r:Object = config.initialRods[i];
			addInitialRod(r.length, r.rotation, r.x, r.y, r.coloured, r.fixed);
		}
	}
	function addInitialRod(length:Number, rotation:Number, x:Number, y:Number, coloured:Boolean, fixed:Boolean) {
		var adjuster = length % 2;
		var rod:RodPlaced = RodPlaced(attachMovie("RodPlaced", config.colourNames[length]+":"+depth, depth++, {config:config, ox:(-config.scaler*(length+adjuster)/2), oy:0}));
		rod._x = x;
		rod._y = y;
		rod._rotation = rotation;
		rod.coloured = coloured;
		rod.fixed = fixed;
		rod.init(length);
		rods.push(rod);
		rod.rods = rods;
		return rod;
	}
	function addRod(len:Number):Rod {
		var adjuster = len % 2;
		var rod:RodPlaced = RodPlaced(attachMovie("RodPlaced", config.colourNames[len]+":"+depth, depth++, {config:config, ox:(-config.scaler*(len+adjuster)/2), oy:0}));
		rod.init(len);
		rod._x = ox;
		rod._y = oy;
		rods.push(rod);
		rod.rods = rods;
		rod.press();
		return rod;
	}
	function panMode() {
		Mouse.addListener(this);
		onMouseDown = myOnMouseDown; 
		onMouseMove = myOnMouseMove;
		onMouseUp = myOnMouseUp;
		panning = true;
	}
	function myOnMouseDown() {
		mouseDown = true;
		var grid = _level0.grid;
		grid.dragx = _level0._xmouse - grid._x;
		grid.dragy = _level0._ymouse - grid._y;
	}
	function myOnMouseMove() {
		if(mouseDown) {
			var grid = _level0.grid;
			grid._x = _level0._xmouse - grid.dragx;
			grid._y = _level0._ymouse - grid.dragy;
		}
	}
	function myOnMouseUp() {
		mouseDown = false;
		//_level0.panel.doArrow();
	}
	function panModeOff() {
		//panRelease();		
		//onRelease = null;//undefined;
		//onPress = null;//undefined;
		onMouseDown = undefined;
		onMouseMove = undefined;
		Mouse.removeListener(this);
		panning = false;
	}
	
}