﻿import ps.logging.Logger;
class Config extends XML {
	public var loaded:Boolean = false;
	var stageW:Number = 550;
	var stageH:Number = 400;
	var scaler:Number = 20;
	var scaleFactor:Number = 1.4142135623731;
	var minScale:Number = -3;
	var maxScale:Number = 3;
	var gridWidth:Number = 5600;
	var gridHeight:Number = 4200;
	var hideButtons:Array;
	var gridBackground:Number = 0xffffff;
	var gridForeground:Number = 0xddddff;
	var colourNames:Array;
	var ncolours:Array;
	var hcolours:Array;
	//var gridMasks:Array;
	var nextScreen:String;
	var prevScreen:String;
	var initialRods:Array;
	var messages:Array;
	var allowRotation:Boolean = false;
	var trashVisible:Boolean = true;
	static var easePoints:Array = [0, -0.0002, 0.0003, 0.0013, 0.003, 0.0054, 0.0083, 0.012, 0.0163, 0.0212, 0.0269, 0.0333, 0.0404, 0.0482, 0.0567, 0.0661, 0.0761, 0.087, 0.0987, 0.1111, 0.1244, 0.1385, 0.1543, 0.1722, 0.1929, 0.2169, 0.2454, 0.28, 0.324, 0.385, 0.5, 0.6016, 0.6633, 0.7087, 0.7446, 0.7742, 0.799, 0.8202, 0.8383, 0.8542, 0.8691, 0.8829, 0.8958, 0.9078, 0.9189, 0.9291, 0.9386, 0.9472, 0.9551, 0.9623, 0.9688, 0.9746, 0.9798, 0.9843, 0.9882, 0.9916, 0.9943, 0.9965, 0.9982, 0.9994];
	//
	//
	//
	function Config(){
		super();
		ignoreWhite = true;
		init();
	}
	function init() {
		hideButtons = [true, true, true, true, true, true, true, true, true, true, true];
		colourNames = [null, "White", "Red", "Green", "Pink", "Yellow", "Dark Green", "Black", "Brown", "Blue", "Orange"];
		ncolours = [null, 0xeeeeee, 0xee0000, 0x00ee00, 0xee00ee, 0xeeee00, 0x007700, 0x222222, 0x774400, 0x0000ee, 0xe87000];
		hcolours = [null, 0xffffff, 0xff0000, 0x00ff00, 0xff00ff, 0xffff00, 0x009900, 0x000000, 0x993300, 0x0000ff, 0xff8800];
		initialRods = [];
		messages = [];
	}
	function allRodsHidden():Boolean {
		for(var i = 0; i < hideButtons.length; i++) {
			if(!hideButtons[i]) {
				return false;
			}
		}
		return true;
	}
	function onLoad(success:Boolean):Void {
		if (!success) {
			trace("config load error("+status+")");
			return;
		}
		//
		// Parse top level element
		//
		var _xml:XMLNode = this.firstChild;
		var i:Number;
		var s:String;
		var b:Boolean;
		//
		i = Number(_xml.attributes["stageW"]);
		if(i != null && !isNaN(i) && i > 0) {
			stageW = i;
			trace("stageW="+stageW);
		}
		//
		i = Number(_xml.attributes["stageH"]);
		if(i != null && !isNaN(i) && i > 0) {
			stageH = i;
			trace("stageH="+stageH);
		}
		//
		i = Number(_xml.attributes["scaler"]);
		if(i != null && !isNaN(i) && i > 0) {
			scaler = i;
			trace("scaler="+scaler);
		}
		//
		i = Number(_xml.attributes["minScale"]);
		if(i != null && !isNaN(i)) {
			minScale = i;
			trace("minScale="+minScale);
		}
		//
		i = Number(_xml.attributes["maxScale"]);
		if(i != null && !isNaN(i)) {
			maxScale = i;
			trace("maxScale="+maxScale);
		}
		//
		i = Number(_xml.attributes["gridWidth"]);
		if(i != null && !isNaN(i) && i > 0) {
			gridWidth = 4*Math.round(i/(4*scaler))*scaler;
			trace("gridWidth="+gridWidth);
		}
		//
		i = Number(_xml.attributes["gridHeight"]);
		if(i != null && !isNaN(i) && i > 0) {
			gridHeight = 4*Math.round(i/(4*scaler))*scaler;
			trace("gridHeight="+gridHeight);
		}
		//
		s = _xml.attributes["gridVisible"];
		if(s=="false") {
			gridForeground = 0xffffff;
			trace("gridForeground="+gridForeground);
		}
		//
		trashVisible = (_xml.attributes["trashVisible"] == "true");
		_level0.trash._visible = trashVisible;
		//
		s = _xml.attributes["nextScreen"];
		if(s== null || s=="") {
			nextScreen = null;
		}
		else {
			nextScreen = s;
			trace("nextScreen="+s);
		}
		//
		s = _xml.attributes["prevScreen"];
		if(s== null || s=="") {
			prevScreen = null;
		}
		else {
			prevScreen = s;
			trace("prevScreen="+s);
		}
		s = _xml.attributes["allowRotation"];
		allowRotation = (s=="true");
		
		for (var n = _xml.firstChild; n; n=n.nextSibling) {
			trace(n.nodeName);
			switch(n.nodeName) {
			case 'rods':
				//Parse list of rods
				for(var m=n.firstChild; m; m=m.nextSibling) {
					var colour:String = m.attributes["colour"];
					var x:Number = indexOfColour(colour);
					if(x > 0) {
						//trace("reveal "+colour);
						hideButtons[x] = false;
					}
					else {
						//trace("hide "+colour);
						hideButtons[x] = true;
					}
				}
				break;
				//
				// initialRods are initialised at start up  
				//
				
			case 'initialRods':
				for(var m=n.firstChild; m; m=m.nextSibling) {
					var length:Number = Number(m.attributes["length"]);
					var rotation:Number = Number(m.attributes["rotation"]);
					var x:Number = Number(m.attributes["x"]);
					var y:Number = Number(m.attributes["y"]);
					var coloured:Boolean = (m.attributes["coloured"] == "true");
					var fixed:Boolean = !coloured || (m.attributes["fixed"] == "true");
					if(!isNaN(length + rotation + x + y)) {
						initialRods.push({length:length, rotation:rotation, x:x, y:y, coloured:coloured, fixed:fixed});
						Logger.log(Logger.INFO, "initialRod: length="+length+" x="+x+" y ="+y+" coloured =" + coloured + " fixed ="+fixed);
					}
				}
				break;
			case 'messages':
				//Parse list of messages
				for(var m=n.firstChild; m; m=m.nextSibling) {
					var s="message["+(m.attributes["name"])+"]";
					s+=m.firstChild.nodeValue;
					trace(s);
					// create an array of messages with the same name
					var name:String = m.attributes["name"];
					if(messages[name] == null) {
						messages[name] = [];
					}
					messages[name].push({
							text:stripEntities(m.firstChild.nodeValue)
						});
					messages[name].x = 0;
				}
				break;
			}
		}
		
		//
		// Callback to final configuration
		//
		_level0.configure();
	}
	function indexOfColour(colour:String):Number {
		for(var i = 0; i < colourNames.length; i++) {
			//trace(colourNames[i]+ "=="+colour);
			if(colourNames[i] == colour) {
				return i;
			}
		}
		return -1;
	}
	/////////////////////////////////////////////////
	// 
	// Utility function to replace XML entities with their text equivalents
	// &lt; -> <
	// &gt; -> >
	// &apos; -> '
	// &quot; -> "
	// &amp; -> &
	//
	// Needed since XMLSpy/Authentic inserts them (Grrr! - but I suppose it
	// means we don't run the risk of badly formed XML)
	//
	static function stripEntities(msg_str:String):String {
		var i = 0;
		var j = 0;
		var s = "";
		if(msg_str == null || msg_str == undefined) {
			return s;
		}
		while((j=msg_str.indexOf("&",i))>=0) {
			//trace("i="+i+" j="+j);
			s += msg_str.substring(i,j);
			i = msg_str.indexOf(";", j+1);
			if(i<0) {
				// lone '&' - not an entity
				return s + msg_str.substring(j);
			}
			var entity = msg_str.substring(j+1,i++);
			switch(entity) {
				case 'lt':
					s += '<';
					break;
				case 'gt':
					s += '<';
					break;
				case 'apos':
					s += '<';
					break;
				case 'quot':
					s += '<';
					break;
				case 'amp':
					s += '<';
					break;
				default:
					Logger.log(Logger.ERROR, "unrecognised entity: &"+ entity +";");
					s += entity;
			}
		}
		s += msg_str.substring(i);
		return s;
	}
	//
	// Messages with the same name are stored in an array. We cycle
	// through these messages as getMessageObject is called.
	//
	public function getMessageObject(name:String):Object {
		var n:Array = messages[name];
		var rv:Object = n[n.x++];
		if(n.x >= n.length) {
			n.x = 0;
			n.nomore = true;
		}
		return rv;
	}
	public function getText(msg:Object):String {
		return msg.text;
	}
	static function ease(t, b, c, d) {
		if (d == 0) {
			t = 1;
		} else {
			t = t/d;
			if (t<0) {
				t = 0;
			}
			if (t>1) {
				t = 1;
			}
		}
		return b+c*easePoints[Math.floor(t*(easePoints.length-1))];
	}
	function snap(v:Number) {
		return Math.round(v/scaler);
	}

}