﻿
class Graph extends MovieClip {
	
	
	//Constructor.
	function Graph() {
		
		//Create a movieclip to house the rectangles.
		this.createEmptyMovieClip("rectangles",this.getNextHighestDepth());
		
		//Button controls.
		this["redUp_btn"].onPress = function() { this._parent.adjust("red",true); }
		this["redDown_btn"].onPress = function() { this._parent.adjust("red",false); }
		this["blueUp_btn"].onPress = function() { this._parent.adjust("blue",true); }
		this["blueDown_btn"].onPress = function() { this._parent.adjust("blue",false); }
		this["greenUp_btn"].onPress = function() { this._parent.adjust("green",true); }
		this["greenDown_btn"].onPress = function() { this._parent.adjust("green",false); }
		this["yellowUp_btn"].onPress = function() { this._parent.adjust("yellow",true); }
		this["yellowDown_btn"].onPress = function() { this._parent.adjust("yellow",false); }
		
		
		//Initialise.
		init();
	}
	
	//Initialise.
	function init():Void {
		
		updateRectangles();
	}
	
	//Adjust a value.
	function adjust(c:String,up:Boolean) {
		//Find index.
		var I:Number;
		if (c=="red") I=0; else if (c=="blue") I=1;	else if (c=="green") I=2; else if (c=="yellow") I=3;
		
		//Change crossing times.
		if (up && this._parent.crossingTimes[I]<40) {
			this._parent.crossingTimes[I]++;
			this._parent["man"+I].updateTime(this._parent.crossingTimes[I]); //Change number on man's head.
		} else if (!up && this._parent.crossingTimes[I]>1) {
			this._parent.crossingTimes[I]--;
			this._parent["man"+I].updateTime(this._parent.crossingTimes[I]);
		}
		
		updateRectangles();
	}
	
	
	
	//Change rectangles.
	function updateRectangles():Void {
		this["rectangles"].clear();
		drawRectangle("red",this._parent.crossingTimes[0]);
		drawRectangle("blue",this._parent.crossingTimes[1]);
		drawRectangle("green",this._parent.crossingTimes[2]);
		drawRectangle("yellow",this._parent.crossingTimes[3]);
	}
	
	
	//Draw a rectangle. Input colour and digit.
	function drawRectangle(c:String,n:Number):Void {
		
		var R = this["rectangles"];
		
		//Find out colour to use and position.
		var col:Number;
		var X:Number;
		if (c=="red") { col=0xff3333; X=100;}
		else if (c=="blue") { col=0x6666ff; X=75;}
		else if (c=="green") { col=0x33ff33; X=50;}
		else if (c=="yellow") { col=0xffff00; X=25;}
		
		//Draw the rectangle.
		R.lineStyle(1,0x000000,0);
		R.beginFill(col,100);
		R.moveTo(X+1,100);
		R.lineTo(X-1+25,100);
		R.lineTo(X-1+25,100-n*2);
		R.lineTo(X+1,100-n*2);
		R.lineTo(X+1,100);
		R.endFill();		
	}
	
}