﻿
class Crossings extends MovieClip {
	
	//The crossing times of the men.
	var crossingTimes:Array;
	
	//Which positions on left and right occupied?
	var leftOccupy:Array;
	var rightOccupy:Array;
		
	//This is a spacing CONSTANT used for positioning men.
	var spacer:Number = 42;
	
	//Which side is the torch on?
	var torch:String = "left";
	
	//Total time so far.
	var time:Number = 0;
	
	//For time.
	var my_fmt1:TextFormat;

	var cross_btn:MovieClip;
	
	//Constructor.
	function Crossings() {
		
		//Initialise left and right occupancy.
		leftOccupy = new Array();
		rightOccupy = new Array();
		
		//What happens when the cross button is pressed.
		cross_btn = this['cross_btn'];
		cross_btn.onPress = crossPress;
		
		//What happens when the reset button is pressed.
		this["reset_btn"].onPress = resetPress;
		
		//What happens when the instructions button is pressed.
		this["instructions_btn"].onPress = function(){
			this._parent["panel"]._visible = (this._parent["panel"]._visible) ? false : true; 
			this._parent["graph"]._visible = false;
		}
		
		
		//What happens when the instructions button is pressed.
		this["times_btn"].onPress = function(){ 
			this._parent["graph"]._visible = (this._parent["graph"]._visible) ? false : true; 
			this._parent["panel"]._visible = false;
		}
		
		//Create the graph.
		this.attachMovie("Graph","graph",this.getNextHighestDepth(),{_x:15,_y:150});
		
		//Bring in the men.
		init();
				
	}
	
	//Reset.
	function resetPress():Void {
		this._parent.init();
	}
	
	//Initialisation procedure.
	function init():Void {
		
		//Remove the old men.
		for (var i:Number = 0; i!=crossingTimes.length; i++) {
			this["man"+i].removeMovieClip();
		}
		
		
		//Create the men.
		for (var i:Number = 0; i!=crossingTimes.length; i++) {
			var col:Number;
			//if (i==0) col=0xcc0000; else if (i==1) col=0x330099; else if (i==2) col=0x006600; else if (i==3) col=0xffcc00;
			if (i==0) col=0xff3333; else if (i==1) col=0x6666ff; else if (i==2) col=0x33ff33; else if (i==3) col=0xffff00;
			var m = Man(attachMovie("Man","man"+i,this.getNextHighestDepth(),{time:crossingTimes[i],position:i,manColour:col}));
			m._x = 150 - i*spacer;
			m._y = 300;
			
			//Reset the occupied array.
			leftOccupy[i] = true;
			rightOccupy[i] = false;	
		}
	
		
		//Torch on the left.
		swapTorch("left");
		
		//Reset time.
		time = 0;
		this["time_txt"].text = ""+time;
		
		//Reset the chosen man back to man 1. redundant i think
		//chosenMan = null;
		
		this["panel"]._visible = true;
		//Make stepper visible.
		this["graph"]._visible = false;
		this["times_btn"]._visible = true;
		this["mc"]._visible = false;
		this["colour_text"]._visible = false;
		
		//Make the finishing text invisible.
		this["finish_txt"]._visible = false;
		
		//Make choose text visible.
		this["choose_txt"]._visible = true;

		//Attach the glow.
		this["glow"].removeMovieClip();
		this.attachMovie("glow","glow",this.getNextHighestDepth(),{_x:105,_y:155})
		this["glow"].blendMode = "add";
		this["glow"]._visible = !this["graph"]._visible;

	}
	
	//Transfer a man from one side to the other. 
	function transfer(man:Man):Void {
		
		if (man.side == "left") {
			
			//Free up spot where man lies.
			leftOccupy[man.position] = false;
			
			//Fill up slot where man moves to.
			var n:Number = freeSpot(rightOccupy);
			rightOccupy[n] = true;
			
			//Man change sides.
			man.side = "right";
			if (manCount()==1) man.moveIt(man._x+215,man._y,"R");
			else if (man._x == 170) man.moveIt(man._x+215+spacer,man._y,"R");
				 else	man.moveIt(man._x+215+spacer,man._y,"N");
			
			man.position = n;
			
		} else if (man.side == "right") {
			
			//Free up spot where man lies.
			rightOccupy[man.position] = false;
			
			//Fill up slot where man moves to.
			var n:Number = freeSpot(leftOccupy);
			leftOccupy[n] = true;
			
			//Man change sides.
			man.side = "left";
			if (manCount()==1) man.moveIt(man._x-215,man._y,"L");
			else if (man._x == 385) man.moveIt(man._x-215-spacer,man._y,"L");
				 else man.moveIt(man._x-215-spacer,man._y,"N");
			man.position = n;
		}
	}
	
	//Find the first free spot.
	function freeSpot(a:Array):Number {
		for (var i:Number = 0; i!=a.length; i++) {
			if (!a[i]) return i;								 
		}
	}
	
	//Cross button pressed.
	function crossPress() {
		var tp = this._parent;
		//trace(this);
		//First check if a man has been selected on the appropriate side.
		var checker:Boolean = false;
		for (var i:Number = 0; i!=tp.crossingTimes.length; i++) {
			if (tp["man"+i].chosen) checker = true;
		}
		
		//Now only do anything if there is somebody selected.
		if (checker) {
			
			//Make the graphs invisible after the first move.
			tp["graph"]._visible = tp["times_btn"]._visible = false;
			
			//Change the side of the torch.
			if (tp.torch=="left") tp.swapTorch("right"); else tp.swapTorch("left");
		
			//Transfer the selected men accross. At the same time, find out the slowest man.
			var slow:Number = 0;
			for (var i:Number = 0; i!=tp.crossingTimes.length; i++) {
				if (tp["man"+i].chosen) {
					tp.transfer(tp["man"+i]);
					if (tp["man"+i].time > slow) slow = tp["man"+i].time;
				}
			}
			
			//Add on time.
			tp.time += slow;
			
			//Now that all men transferred across, change selectability.
			tp.torchTest();
			
			//Change time.
			tp["time_txt"].text = ""+tp.time;
						
		}	
	}

	
	//This function works out whichever side the torch is on, and makes all men on the other side unselectable.
	function torchTest():Void {
		//Change selectability depending on side AND unhighlight everyone.
		for (var i:Number = 0; i!=crossingTimes.length; i++) {
			//this["man"+i].chosen = false;
			this["man"+i].select = (this["man"+i].side == torch) ? true : false;
		}
	}
	
	//Count the number of selected men on the side of the torch. Return number of men.
	function manCount():Number {
		var c:Number = 0;
		for (var i:Number = 0; i!=crossingTimes.length; i++) 
			if (this["man"+i].chosen) c++;
		
		return c;
	}
	
	//Move all men back to from the bridge.
	function selectNone():Void {
		for (var i:Number = 0; i!=crossingTimes.length; i++)
			if (this["man"+i].chosen)
				this["man"+i].chooseMan();
	}
	
	//Move a man up next to the bridge, or back from the bridge.
	function changeChosenMan(n:Number):Void {
		//If the man is currently chosen then move him back. If he is not chosen the move him forward.
		if (!this["man"+n].chosen) {
			//Move him back.
			if (torch=="left") this["man"+n].moveIt(150 - this["man"+n].position*spacer,300,"N");
			else if (torch=="right") this["man"+n].moveIt(400 + this["man"+n].position*spacer,300,"N");
			
			//If there is a still another man up there then move him across.
			var c:Number = null;
			for (var i:Number = 0; i!=4; i++) 
				if (this["man"+i].chosen) 
					if (torch=="left") this["man"+i].moveIt(170,this["man"+i]._y,"N");
					else if (torch=="right") this["man"+i].moveIt(385,this["man"+i]._y,"N");

		} else if (this["man"+n].chosen) {
			//Move him up.
			if (torch=="left" && manCount()==1) this["man"+n].moveIt(170,170,"N"); 
			else if (torch=="left" && manCount()==2) this["man"+n].moveIt(170-spacer,170,"N");
			else if (torch=="right" && manCount()==1) this["man"+n].moveIt(385,170,"N"); 
			else if (torch=="right" && manCount()==2) this["man"+n].moveIt(385+spacer,170,"N");
		}
	}
	
	
	//Compute the minimum for our selection of people. ONLY WORKS FOR FOUR PEOPLE. Don't know general formula.
	function computeMinimum():Number {
		var a:Array = new Array(4);
		for (var i:Number = 0; i < 4; i++)
			a[i] = crossingTimes[i];
		//trace("before = "+a);
		a.sort(Array.NUMERIC );
		//trace("after = "+a);
		
		return a[0]+a[1]+a[3]+Math.min(2*a[1],a[0]+a[2]);
	}
	
	//Test if all men have made it to the other side.
	function testSide():Boolean {
		var b:Boolean = true;
		for (var i:Number = 0; i!=crossingTimes.length; i++) 
			if (this["man"+i].side == "left") b = false;
		return b;
	}
	
	//Swap sides of the torch.
	function swapTorch(s:String):Void {
		if (s=="right") {
			torch = "right";
			this["glow"]._x = 340;
			this["choose_txt"]._x = 365;
		} else if (s=="left") {
			torch = "left";
			this["glow"]._x = 105;
			this["choose_txt"]._x = 3;
		}
	}
	
	//Makes all buttons selectable or unselectable.
	function nullify(yes:Boolean):Void {
		this["instructions_btn"].selectable = (yes) ? true : false;
		this["times_btn"].selectable = (yes) ? true : false;
		this["cross_btn"].selectable = (yes) ? true : false;
		this["reset_btn"].selectable = (yes) ? true : false;	
		for (var i:Number = 0; i!=4; i++)
			this["man"+i].select1 = (yes) ? true : false;
	}
	
	//Test if finished.
	function testFinish():Void {
//		trace("testFinish called: this="+this);
		if (testSide()) {
			this["choose_txt"]._visible = false;
			this["finish_txt"]._visible = true;
			if (this.computeMinimum() == this.time) 
				this["finish_txt"].text = "Congratulations, you have finished in the fastest possible time!";
			else 
				this["finish_txt"].text = "You finished in "+this.time+ " minutes. Can you do better?"
		}
	}
}

