﻿/**
	SnapSet:
	
 	Use this class if you want an object to snap to a number of different drop zones.

	The idea is that you draw all the drop zones as MovieClips and make them 
	all class Snapper. The centre of the object will snap to the centre of any Snapper drop zone it lands on.
	
	Make a SnapSet with:
	
		var snapSet:SnapSet = new SnapSet();
	
	and then add all your snappers into the snapSet by calling addSnapper as many times as you need.
	
		snapSet.addSnapper(aSnapper);
	
	At the end of a drag, onRelease can now discover what happened by calling:
	
		snapSet.inside(this);   // assuming that 'this' refers to the dragged object. 
	
	Also:
		var snapper:Snapper = snapSet.inside();
	
	will return the snapper you hit (or null if you hit none of them) so you can then snap to it by calling
	
		snapper.snap(this).

*/
	
class SnapSet {
	
	var snappers:Array;
	
	function SnapSet() {
		snappers = new Array();
	}
	
	function addSnapper(snapper:Snapper):Void {
		snappers.push(snapper);
	}
	
	function inside(ob:Object):Snapper {
		for (var i:Number = 0; i<snappers.length; i++) {
			if( snappers[i].inside(ob)) {
				return snappers[i];
			}
		}
		return null;
	}
}