﻿class ConnectThree extends MovieClip {
	var depth:Number = 0;
	var numPos:Number;
	var numNeg:Number;
	var sign:Number;
	var allSums:Array;
	var dicePos:MovieClip;
	var diceNeg:MovieClip;
	var plus:MovieClip;
	var minus:MovieClip;
	var board:MovieClip;
	var box:TextField;
	var newTurn:Boolean = true;
	var turn:Boolean; // true for players turn
	var gameOver:Boolean = false;
	var t0:Number;
	var t1:Number;
	var numOfPls:Number = 1; // number of players: 1 - against computer, 2 - against friend
	function ConnectThree() {
		init();
		turn = true;// player starts at the moment, I should add an option who starts
		box.text = "Your turn. Roll the dice.";
	}
	function init() {
		allSums = new Array;
		dicePos = this["dicePos"];
		diceNeg = this["diceNeg"];
		plus = this["plus"];
		minus = this["minus"];
		board = this["board"];
		box = this["box"];
	}
	// reset dice for new turn
	function resetDice() {
		dicePos.reset();
		diceNeg.reset();
		dicePos._visible = false;
		diceNeg._visible = false;
		plus.reset();
		minus.reset();
		plus.placed = 0;
		minus.placed = 0;
		newTurn = true;
		if ((numOfPls == 1) && (!turn)) turn = true;
		if ((numOfPls == 2)) turn = !turn;		
		if (numOfPls == 1) box.text = "Your turn. Roll the dice.";
		else if (turn) box.text = "Red player's turn. Roll the dice.";
		else box.text = "Blue player's turn. Roll the dice.";
	}
	// restart whole game
	function restart() {
		if (numOfPls == 2) turn = false;
		else turn = true;
		resetDice();
		board.removeCounters();
		gameOver = false;
		onEnterFrame = null;
		board.onEnterFrame = null;
	}
	function rollDice() {
		trace("roll ----------------");
		if (newTurn) {
			if ((turn && (numOfPls == 1)) || (numOfPls == 2)) box.text = "Drag the dice and the sign into the squares to get the sum you wish.";
			newTurn = false;
			numPos = randomNumber();
			numNeg = randomNumber();
			allSums = findAllSums();
			trace("all sums: "+allSums);
			sign = 0;
			dicePos.dicePosText.text = numPos;
			dicePos._visible = true;
			diceNeg.diceNegText.text = numNeg;
			diceNeg._visible = true;
		}
	}
	function placeCounter() {
		if (turn) {
			place(true);
		}
		else place(false);
	}
	function place(colour:Boolean) {
		var sum:Number;
		if ((plus.placed == 1) && (minus.placed == 0)) {
			sign = 1;
		}
		else if ((plus.placed == 0) && (minus.placed == 1)) {
			sign = -1;
		}	
		if ((dicePos.placed == 1) && (diceNeg.placed == 2) && (sign != 0)) {
			sum = numPos +sign*numNeg;
		}
		else if ((dicePos.placed == 2) && (diceNeg.placed == 1)  && (sign != 0)) {
			sum = numNeg + sign*numPos;
		}
		else {
			sum = 13;
		}
		if (sum == 13) {
			box.text = "Place the dice and the sign first.";
			//trace("place the dice first");
		}
		else {
			board.addCounter(colour,sum);
		}
	}
	function endPlace(colour:Boolean) {
		resetDice();
		var added:Number = board.counterAdded;
		switch (numOfPls) {
			case 1: 
				if ((added == 0) && colour) {
					newTurn = true;
					computersTurn();
				}
				else if ((added == 0) && (!colour)) {
					newTurn = true;
				}
				else if (added == 1) {
					endGame(1);
				}
				else if (added == 2) {
					endGame(2);
				}
				break;
			case 2: 
				if ((added == 0) && colour) {
					newTurn = true;
					turn = false;
				}
				else if ((added == 0) && (!colour)) {
					newTurn = true;
					turn = true;
				}
				else if (added == 1) {
					endGame(1);
				}
				else if (added == 2) {
					endGame(2);
				}
				break;
		}
	}
	function pass() {
		var emptySpace:Boolean = false;
		for (var i:Number = 0; i<3; i++) {
			if (board.board[allSums[i]+6] == 0) {
				emptySpace = true;
				break;
			}
		}
		if (emptySpace) {
			box.text = "There is no need to pass!";
		}
		else {
			box.text = "Yes, you have to pass!";
			setAnimation(_global.animatePass,2500);
		}
	}
	function computersTurn() {
		turn = false;
		box.text = "Computer's turn now...";
		rollDice();
		//make list of emty places where the computer can place a counter
		//list of all sums is in allSums
		var list:Array;
		var doAnim:Function;
		list = new Array;
		for (var i:Number = 0; i<3; i++) {
			if (board.board[allSums[i]+6] == 0) {
				list[i] = 1;
			}
			else {
				list[i] = 0;
			}
		}
		//trace("list: "+list);
		//find empty spaces
		var emptySpaces:Number = list[0]+list[1]+list[2];
		//trace("empty spaces: "+emptySpaces);
		if (emptySpaces == 0) {
			box.text = "Computer has to pass!";
			setAnimation(_global.animatePass,2500);
		}
		//yes, there is one empty space
		else if (emptySpaces == 1) {
			//trace("place to only one empty space");
			if (list[0] == 1) { doAnim = _global.doAnim1; }
			else if (list[1] == 1) { doAnim = _global.doAnim2; }
			else if (list[2] == 1) { doAnim = _global.doAnim3; }
		}
		// there are more possibilities	- chose one
		else {
			doAnim = findStrategy(list);
		}
		setAnimation(doAnim,3000);
	}
	// return _global.doAnim1--_global.doAnim3;
	function findStrategy(ll:Array):Function {
		var opt:Array = new Array;
		for (var ii:Number = 0; ii<3; ii++) {
		if (ll[ii] == 1) {	
			//trace("allSums[ii]: "+allSums[ii]);		
			var i:Number = Math.floor((allSums[ii]+6)/5);
			var j:Number = allSums[ii] + 6 - 5*i;
			//trace("(i,j) = ("+i+","+j+")");
			for (var k:Number = i-1; k<=i+1; k++) {
				for (var l:Number = j-1; l<=j+1; l++) {
					if ((k == i) && (l == j)) {
						//trace("skip");
					}
					else if ((k >=0 ) && (l >=0 ) && (k < 5 ) && (l < 5)) {
						//explore the square [k,l], eg: 5*k+l-12
						if (board.board[5*k+l] != 0) {
							var di:Number = k-i;
							var dj:Number = l-j;
							if (((k+di) >=0 ) && ((l+dj) >=0 ) && ((k+di) < 5 ) && ((l+dj) < 5)) {		
								if (board.board[5*(k+di)+l+dj] == board.board[5*k+l]) {
									if (board.board[5*k+l] == 1) {
										//computer can block - add to the list
										opt[ii] = 1;
									}
									else {
										//place where computer can win - add to the list
										//trace("found the place where I can win");
										opt[ii] = 2;
									}
								}
							}
							if (((k-2*di) >=0 ) && ((l-2*dj) >=0 ) && ((k-2*di) < 5 ) && ((l-2*dj) < 5)) {									
								if (board.board[5*(k-2*di)+l-2*dj] == board.board[5*k+l]) {
									if (board.board[5*k+l] == 1) {
										//computer can block - add to the list
										opt[ii] = 1;
									}
									else {
										//place where computer can win - add to the list
										//trace("found the place where I can win");
										opt[ii] = 2;
									}
								}
							}
						}
					}
				}
			}
		}
		}
		//trace("options: "+opt);
		for (var ii:Number = 0; ii<3; ii++) {
			if (opt[ii] == 2) {
				//trace("win: "+ii);
				if (ii == 0) { return _global.doAnim1; }
				else if (ii == 1) { return _global.doAnim2; }
				else if (ii == 2) { return _global.doAnim3; }
			}
		}
		for (var ii:Number = 0; ii<3; ii++) {
			if (opt[ii] == 1) {
				//trace("block: "+ii);
				if (ii == 0) { return _global.doAnim1; }
				else if (ii == 1) { return _global.doAnim2; }
				else if (ii == 2) { return _global.doAnim3; }
			}
		}
		for (var ii:Number = 0; ii<3; ii++) {
			if (ll[ii] == 1) {
				//trace("empty space: "+ii);
				if (ii == 0) { return _global.doAnim1; }
				else if (ii == 1) { return _global.doAnim2; }
				else if (ii == 2) { return _global.doAnim3; }
			}
		}
	}
	function endGame(who:Number) {
		gameOver = true;
		newTurn = false;
		switch (numOfPls) {
			case 1:
				switch(who) {
					case 1: box.text = "You win!!!"
						break;
					case 2: box.text = "Computer wins!!!"
						break;
				}
				break;
			case 2:
				switch(who) {
					case 1: box.text = "Red player wins!!!"
						break;
					case 2: box.text = "Blue player wins!!!"
						break;
				}
				break;
		}
		board.drawLine(who);
	}
	function randomNumber():Number {
		var a:Number = Math.random()*6;
		if (a < 1) return 1;
		else if (a < 2) return 2;
		else if (a < 3) return 3;
		else if (a < 4) return 4;
		else if (a < 5) return 5;
		else return 6;
	}
	function findAllSums():Array {
		var a:Array;
		a = new Array;
		a[0] = numPos + numNeg;
		a[1] = numPos - numNeg;
		a[2] = numNeg - numPos;
		return a;
	}
	function setAnimation(animFunction:Function,duration:Number) {
		if (onEnterFrame == null) {
			trace("animation");
			t0 = getTimer();
			t1 = t0 + duration;
			onEnterFrame = animFunction;
		}
	}
}